﻿import es, popuplib, services, cfglib, cmdlib, gamethread
import path, os


info = es.AddonInfo()
info.name     = "Addon Manager"
info.version  = "2.3.1"
info.url      = "http://forums.mattie.info/cs/forums/viewtopic.php?p=257533"
info.basename = "addon_manager"
info.author   = "DanielB"
es.ServerVar('addon_manager_ver', info.version, 'Addon Manager by DanielB').makepublic()


################################################
# Globals

addon_name = 'addon_manager'

default_ignore = 'benchmark;corelib;crontab;diag;examples;itemmem;keymenu;pybenchmark;pyunittest;schedule;setting;unittest;vote'

addons = {}
subAddons = {}

addondir = path.path(es.ServerVar('eventscripts_addondir')) 

addons_popup      = None # Main menu [list of addons]
addon_popup       = None # Submenu   [addon specific info/functions]
sub_addons_popup  = None # SubAddons [List of subaddons of a specific addon]

# HL2:DM Fix
if not popuplib.langdata.has_key('default'):
    popuplib.langdata['default'] = {'prev':'Назад', 'next':'Вперед', 'quit':'Выход', 'pending':'pending'}

################################################
# Classes

class addon_base:
    def isLoaded(self):
        if self.type == 'txt':
            return es.exists('script', self.loadname)
            
        for module in es.addons.getAddonList():
            if module.__name__.rsplit('.', 1)[0].replace('.', '/') == self.loadname:
                return True
        return False 
            
    def getInfo(self):
        if self.type == 'py':
            if self.isLoaded():
                addonInfo = es.addons.getAddonInfo(self.loadname)
                if not addonInfo is None:
                    if addonInfo.has_key('name'):
                        self.name = addonInfo['name']
                    if addonInfo.has_key('author'):
                        self.author = addonInfo['author']
                    if addonInfo.has_key('version'):
                        self.version = addonInfo['version']
            elif settings.parsefiles:
                filepath = self.loadname + '/' + self.loadname.split('/')[-1] + '.py'
                name, author, version = parseFile(filepath)
                if name:
                    self.name = name
                if author:
                    self.author = author
                if version:
                    self.version = version
        

class Addon(addon_base):
    def __init__(self, sType, version, loadname, name, author):
        self.type = sType
        self.version = version
        self.loadname = loadname
        self.name = name
        self.author = author
        
        self.getInfo()
          

class SubAddon(addon_base):
    def __init__(self, sType, version, loadname, name, author):
        self.type = sType
        self.version = version
        self.loadname = loadname
        self.name = name
        self.author = author
        self.baseaddon = loadname.split('/')[0]
        
        self.getInfo()
        
class Settings(object):
    config = cfglib.AddonCFG(es.getAddonPath('addon_manager') + '/settings.cfg')
   
    config.text('*****************************')
    config.text('Addon Manager v%s'%info.version)
    config.text('Easily manage all your Eventscripts addons from one easy popup!')
    config.text('*****************************')
    config.text('Settings')
    config.text('*****************************')
   
    _parsefiles  = config.cvar('am_parsefiles',              0,  'Should files be parsed? (Slower, but info for unloaded addons can be retrieved)'),  bool
    _ignore      = config.cvar('am_ignore',     default_ignore,  'What scripts should not be included in admin popup, seperated with a ;'),  str
    _admins      = config.cvar('am_admins',    'STEAM_ID_LAN;',  'Steamids of players with access to admin popup (If not using auth), seperated with a ;'),  str
    _alpha       = config.cvar('am_alpha',    1,  'Should Addons be sorted alphabetically? (1 = yes, 0 = no)'),  bool
    
    _excepthook = config.cvar('am_excepthook',    1,  'Display if an error has occured in addons page?'),  bool
   
    config.execute()
   
    def __init__(self):
        self.config.write()
        
    def __getattr__(self, name):
        if hasattr(Settings, name):
            return super(Settings, self).__getattribute__(name)
           
        elif hasattr(Settings, '_'+name):
            val, func = super(Settings, self).__getattribute__('_'+name)
            return func(val)
           
        raise AttributeError, 'No such attribute "%s"'%name

settings = Settings()


################################################
# ES-Stuff

def msg(text):
    es.msg('#multi', '#green[AddonManager]#lightgreen '+text)
    
def tell(userid, text):
    es.tell(userid, '#multi', '#green[Addon Manager]#lightgreen '+text)

def load():
    cmdlib.registerServerCommand('addon_manager', cmd_manage, 'Used to add Addon_manager support or ESS scripts syntax: addon_manager <basename> <addon name> <author> <version>')
    cmdlib.registerSayCommand('!addons', cmd_addons, 'Show Addon manager Menu')
    cmdlib.registerServerCommand('am_load', cmd_load, 'Load scripts and set information: am_load <basename> <addon name> <author> <version>')
    parseAddons()
    setupAuth()
    msg('Loaded v%s'%info.version)
    
def unload():
    cmdlib.unregisterServerCommand('addon_manager')
    cmdlib.unregisterSayCommand('!addons')
    cmdlib.unregisterServerCommand('am_load')
    msg('Unloaded')
    
################################################
# Parser

def parseAddons():
    global addons, subAddons, addons_popup
    to_ignore = str(settings.ignore).split(';')
    ess, py = getAddonList()
    for addon in ess:
        if not addon in to_ignore:
            if '/' in addon: #if sub addon
                subAddons[addon] = SubAddon('txt', 'unknown', addon, addon, 'unknown')
            else:
                addons[addon] = Addon('txt', 'unknown', addon, addon, 'unknown')
    for addon in py:
        if not addon in to_ignore:
            if '/' in addon: #if sub addon
                subAddons[addon] = SubAddon('py', 'unknown', addon, addon, 'unknown')
            else:
                addons[addon] = Addon('py', 'unknown', addon, addon, 'unknown')
    
    addons_popup = popuplib.easymenu('am_main', None, main_handler)
    addons_popup.settitle('Установленые плагины')
    
    addonlist = list(addons)
    if settings.alpha:
        addonlist.sort()
    for addon in addonlist:
        addons_popup.addoption(addon, addons[addon].name)
    es.dbgmsg(3, '[Addon Manager] Initial Parse complete')
        
        
def parseFile(filepath):
    filepath = os.sep.join((addondir, filepath))
    name, author, version = False, False, False
    
    a = open(filepath, 'r', 256)
    b = a.readlines()
    a.close()
    for j in b:
        if j.startswith('info.'):
            if j[5:12] == 'version':
                j = j.replace("'", '"')
                args = j.split('"')
                if len(args) > 1:
                    version = args[1]
            elif j[5:9] == 'name':
                j = j.replace("'", '"')
                args = j.split('"')
                if len(args) > 1:
                    name = args[1]
            elif j[5:11] == 'author':
                j = j.replace("'", '"')
                args = j.split('"')
                if len(args) > 1:
                    author = args[1]
        elif j.startswith('info['):
                j = j.replace("'", '"')
                if j[6:10] == 'name':
                    j = j.split('"')
                    if len(j) > 2:
                        name = j[-2]
                elif j[6:13] == 'version':
                    j = j.split('"')
                    if len(j) > 2:
                        version = j[-2]
                elif j[6:12] == 'author':
                    j = j.split('"')
                    if len(j) > 2:
                        author = j[-2]
                        
    return name, author, version
        
################################################
# Popup Control

def main_handler(userid, choice, popupname):
    global addon_popup
    
    if popuplib.exists(popupname): popuplib.delete(popupname)
    
    if choice in addons:
        addon = addons[choice]
        popupname = 'am_info_%s'%choice
        if popuplib.exists(popupname): popuplib.delete(popupname)
        addon_popup = popuplib.create(popupname)
        addon_popup.addline(addon.name)
        addon_popup.addline('--------------------')
        addon_popup.addline('Автор  : %s'%addon.author)
        addon_popup.addline('Версия : %s'%addon.version)
        addon_popup.addline('Тип    : %s'%addon.type)
        
        if settings.excepthook:
            basename = addon.loadname.split('/')[-1]
            errorfile = os.sep.join((addondir, addon.loadname, basename+'_errors.txt'))
            es.dbgmsg(0, errorfile)
            if os.path.isfile(errorfile):
                addon_popup.addline('Содержит ошибки!')
            else:
                addon_popup.addline('Не содержит ошибки')
        
        if addon.isLoaded():
            addon_popup.addline('->1 - Выключить плагин')
        else:
            addon_popup.addline('->1 - Включить плагин')
        
        if hasSubAddon(addon.loadname):
            addon_popup.addline('->2 - Просмотреть папки')
        
        addon_popup.addline('->3 - Назад')
        
        addon_popup.addline('0 - Выход')
        
        addon_popup.menuselect = info_handler
        
        addon_popup.send(userid)

def info_handler(userid, choice, popupname):
    global sub_addons_popup
    if popuplib.exists(popupname): popuplib.delete(popupname)
    
    addon_name = popupname[len('am_info_'):]
    addon = addons[addon_name]
    
    if choice == 1:
        if addon.isLoaded():
            es.unload(addon_name)
        else:
            es.load(addon_name)
            addon.getInfo()
            
        gamethread.delayed(0.1, main_handler, (userid, addon_name, 'am_main'))
    
    if choice == 2:
        subs = getSubAddons(addon_name)
        if popuplib.exists('am_subaddon_menu'): popuplib.delete('am_subaddon_menu')
        sub_addons_popup = popuplib.easymenu('am_subaddon_menu', None, sub_handler)
        sub_addons_popup.settitle('Папки плагина '+addon_name)
        
        for i in subs:
            sub_addons_popup.addoption(i, subAddons[i].name)
        
        sub_addons_popup.send(userid)
        
    
    elif choice == 3:
        addons_popup.send(userid)

def sub_handler(userid, choice, popupname):
    global addon_popup
    if choice in subAddons:
        addon = subAddons[choice]
        pop_name = 'am_subaddons_info_%s'%choice
        if popuplib.exists(pop_name): popuplib.delete(pop_name)
        addon_popup = popuplib.create(pop_name)
        addon_popup.addline(addon.name)
        addon_popup.addline('--------------------')
        addon_popup.addline('Автор  : %s'%addon.author)
        addon_popup.addline('Версия : %s'%addon.version)
        addon_popup.addline('Тип    : %s'%addon.type)
        
        if addon.isLoaded():
            addon_popup.addline('->1 - Выключить плагин')
        else:
            addon_popup.addline('->1 - Включить плагин')
        
        addon_popup.addline('->3 - Назад')
        
        addon_popup.addline('0 - Выход')
        
        addon_popup.menuselect = sub_info_handler
        
        addon_popup.send(userid)

def sub_info_handler(userid, choice, popupname):
    addon_name = popupname[len('am_subaddons_info_'):]
    addon = subAddons[addon_name]
    if choice == 1:
        if addon.isLoaded():
            es.unload(addon_name)
        else:
            es.load(addon_name)
            addon.getInfo()
            
        gamethread.delayed(0.1, sub_handler, (userid, addon_name, ''))
     
    elif choice == 3:
        main_handler(userid, addon.baseaddon, '')

        
        
################################################
# Misc Commands

def getSubAddons(loadname=None):
    if loadname is None:
        return list(subAddons)
        
    addon = addons[loadname]
    return filter(lambda x: subAddons[x].baseaddon == addon.loadname, subAddons)

def hasSubAddon(loadname):
    for addon in subAddons:
        if subAddons[addon].baseaddon == loadname:
            return True
    return False
    
def setupAuth():
    global isAuthed
    if services.isRegistered('auth'):
        auth_service = services.use('auth')
        auth_service.registerCapability('manage_addons', auth_service.ADMIN)
        isAuthed = lambda x: auth_service.isUseridAuthorized(x, 'manage_addons')
    else:
        isAuthed = lambda x: False
        
def auth(userid):
    if isAuthed(userid): return True
    return es.getplayersteamid(userid) in settings.admins.split(';')
    
    
def getAddonList():
    addonlen = len(addondir.splitall())
    ess = []
    py = []
    for f in addondir.walkfiles():
        fsplit = f.splitall()
        
        if f.namebase == fsplit[~1]:
            if f.name == f.namebase + '.py':
                name = '/'.join(fsplit[addonlen:~0])
                if name in ess: ess.remove(name)
                py.append(name)
                
        elif f.namebase == 'es_'+fsplit[~1]:
            if f.name == f.namebase + '.txt':
                name = '/'.join(fsplit[addonlen:~0])
                if name not in py:
                    ess.append(name)
                
    return ess, py
    
    
################################################
# Console Commands

def am_load():
    basename = es.getargv(1)
    name = es.getargv(2)
    author = es.getargv(3)
    version = es.getargv(4)
    if addons.has_key(basename):
        if not addons[basename].isLoaded():
            gamethread.delayed(1, set_info, (basename, name, author, version))
        else:
            es.dbgmsg(0, 'Плагин уже загружен.Отключите его и попробуйте снова.')
    else:
        es.dbgmsg(0, 'Either the script doesn\'t exist, or it is a sub-script')
        
        
def cmd_manage(args):
    if len(args) != 4:
        es.dbgmsg(0, 'Invalid addon_manager syntax!')
        return
        
    basename, name, author, version = args
    if basename in addons:
        if addons[basename].name == addons[basename].loadname:
            addons[basename].name = name
        else:
            es.dbgmsg(0, '[AM]Failed to set name of %s'%basename)
            
        if addons[basename].author == 'неизвестный':
            addons[basename].author = author
        else:
            es.dbgmsg(0, '[AM]Failed to set author of %s'%basename)
            
        if addons[basename].version == 'неизвестная':
            addons[basename].version = version
        else:
            es.dbgmsg(0, '[AM]Failed to set version of %s'%basename)
            
    elif basename in subAddons:
        if subAddons[basename].name == subAddons[basename].loadname:
            subAddons[basename].name = name
        else:
            es.dbgmsg(0, '[AM]Failed to set name of %s'%basename)
            
        if subAddons[basename].author == 'неизвестный':
            subAddons[basename].author = author
        else:
            es.dbgmsg(0, '[AM]Failed to set author of %s'%basename)
            
        if subAddons[basename].version == 'неизвестная':
            subAddons[basename].version = version
        else:
            es.dbgmsg(0, '[AM]Failed to set version of %s'%basename)
    else:
        es.dbgmsg(0, '[AM]Unable to find addon "%s"'%basename)
    
    
import sys, traceback

def cmd_addons(userid, args):
    try:
        if auth(userid):
            addons_popup.send(userid)
        else:
            tell(userid, 'Вы не админ!')
    except:
        msg('Error Sending Addons Popup')
        for line in traceback.format_exception(*sys.exc_info()):
            msg(line.strip())
    
def cmd_load(args):
    if len(args) != 4:
        es.dbgmsg(0, '[AM]Invalid am_load syntax!')
        return
    basename, name, author, version = args
    
    if basename in addons:
        if not addons[basename].isLoaded():
            es.load(basename)
            cmd_manage(args)
        else:
            es.dbgmsg(0, '[AM][%s] уже включен!'%basename)
            
    elif basename in subAddons:
        if not subAddons[basename].isLoaded():
            es.load(basename)
            cmd_manage(args)
        else:
            es.dbgmsg(0, '[AM][%s] уже выключен!'%basename)
    
    else:
        es.dbgmsg(0, '[AM]Плагин не найден [%s]. Загрузка...'%basename)
        es.load(basename)
        
        
################################################
# API Commands

#def getSubAddons(loadname=None):

#def hasSubAddon(loadname):

def isLoaded(basename):
    if basename in addons:
        return addons[basename].isLoaded()
    elif basename in subAddons:
        return subAddons[basename].isLoaded()
    return 0
    
def getInfo(basename):
    if basename in addons:
        x = addons[basename]
        return (x.name, x.version, x.author)
    elif basename in subAddons:
        x = subAddons[basename]
        return (x.name, x.version, x.author)
    else:
        return 0
    
def getName(basename):
    if basename in addons:
        return addons[basename].name
    elif basename in subAddons:
        return subAddons[basename].name
    return 0

def getAuthor(basename):
    if basename in addons:
        return addons[basename].author
    elif basename in subAddons:
        return subAddons[basename].author
    return 0
        
def getVersion(basename):
    if basename in addons:
        return addons[basename].version
    elif basename in subAddons:
        return subAddons[basename].version
    return 0

def getAddonInstance(loadname):
    if basename in addons:
        return addons[basename]
    elif basename in subAddons:
        return subAddons[basename]
        
    return None
    
 
    