﻿# -*- coding:Utf-8 -*-

# ========================================
#  IMPORTATIONS                          #
# ========================================

import es
import langlib

import os
import shelve
import datetime

import psyco
psyco.full()

# ========================================
#  INFORMATIONS                          #
# ========================================

informations = es.AddonInfo()
informations.version     = '2.2'
informations.basename    = 'showdamage'
informations.name        = 'Show-Damage'
informations.author      = 'L\'In20Cible'
informations.url         = 'http://addons.eventscripts.com/addons/view/showdamage'
informations.description = 'Indique les dommages causés directement au milieu de son écran.'

es.ServerVar('sd_version', (informations.version + ' by ' + informations.author)).makepublic()

# ========================================
#  INITIALISATION                        #
# ========================================

def load():
   Initialization()
   
def Initialization():
   global players, settings, database, translations
   players = {}
   settings = {'enable': '0',
               'status': '0',
               'advert': '0',
               'saycmd': '!showdamage'}
   for setting in settings:
      settings[setting] = es.ServerVar(('sd_' + setting), settings[setting])
   folderpath = os.path.join(str(es.ServerVar('eventscripts_addondir')), informations.basename, 'configuration').replace(os.sep, '/')
   if not os.path.isdir(folderpath):
      os.mkdir(folderpath)
   filepath = GetConfigurationFilePath('configuration.cfg')
   if not os.path.isfile(filepath):
      file = open(filepath, 'w')
      for string in ['// Voulez-vous activer le Show-Damage sur votre serveur?\n',
                     '//\n',
                     '// 1 = Oui\n',
                     '// 0 = Non\n',
                     '\n',
                     'sd_enable "1"\n',
                     '\n',
                     '// Voulez-vous que le Show-Damage soit activé par défaut pour les nouveaux joueurs?\n',
                     '//\n',
                     '// 1 = Oui\n',
                     '// 0 = Non\n',
                     '\n',
                     'sd_status "1"\n',
                     '\n',
                     '// Définissez la commande t\'chat qui permettra aux joueurs d\'activer et de désactiver le Show-Damage.\n',
                     '\n',
                     'sd_saycmd "!showdamage"\n',
                     '\n',
                     '// Voulez-vous annoncer aux joueurs la commande t\'chat qu\'ils doivent utiliser au début de chaque round?\n',
                     '//\n',
                     '// 1 = Oui\n',
                     '// 0 = Non\n',
                     '\n',
                     'sd_advert "1"']:
         file.write(string)
      file.close()
   es.server.queuecmd(('es_xmexec ' + os.path.join('..', 'addons', 'eventscripts', informations.basename, 'configuration', 'configuration.cfg').replace(os.sep, '/')))
   database = shelve.open(os.path.join(str(es.ServerVar('eventscripts_addondir')), informations.basename, 'database.db').replace(os.sep, '/'), writeback = True)
   filepath = GetConfigurationFilePath('translations.ini')
   if not os.path.isfile(filepath):
      file = open(filepath, 'w')
      for string in ['[advert]\n',
                     '"en" = "Type #lightgreen$saycmd #defaultfor enable/disable the Show-Damage."\n',
                     '"fr" = "Tapez #lightgreen$saycmd #defaultpour activer/désactiver le Show-Damage."\n',
                     '"de" = "Schreibe #lightgreen$saycmd #default, um Show-Damage ein/auszuschalten."\n',
                     '\n',
                     '[enable]\n',
                     '"en" = "You #lightgreenactivated #defaultthe Show-Damage."\n',
                     '"fr" = "Vous avez #lightgreenactivé #defaultle Show-Damage."\n',
                     '"de" = "Du hast Show-Damage #lightgreeneingeschaltet#default."\n',
                     '\n',
                     '[disable]\n',
                     '"en" = "You #lightgreendeactivated #defaultthe Show-Damage."\n',
                     '"fr" = "Vous avez #lightgreendésactivé #defaultle Show-Damage."\n',
                     '"de" = "Du hast Show-Damage #lightgreenausgeschaltet#default."\n',
                     '\n',
                     '[nodamage]\n',
                     '"en" = "You did no damage on this round."\n',
                     '"fr" = "Vous n\'avez pas causé de dommage sur ce round."\n',
                     '"de" = "Du hast diese Runde keinen Schaden gemacht."\n',
                     '\n',
                     '[showdamage]\n',
                     '"en" = "You\'ve done a total of #lightgreen$damages #defaultdamages on this round."\n',
                     '"fr" = "Vous avez causé un total de #lightgreen$damages #defaultdommages sur ce round."\n'
                     '"de" = "Du hast in dieser Runde insgesamt #lightgreen$damages #defaultSchaden gemacht."',]:
         file.write(string)
      file.close()
   translations = langlib.Strings(filepath)
   
def unload():
   database.close()

# ========================================
#  UTILITAIRES                           #
# ========================================

def GetConfigurationFilePath(filename):
   return os.path.join(str(es.ServerVar('eventscripts_addondir')), informations.basename, 'configuration', filename).replace(os.sep, '/')
   
def GetPlayerSteamID(userid):
   userid = int(userid)
   usersteamid = None
   if not es.isbot(userid):
      usersteamid = es.getplayersteamid(userid)
      if int(es.ServerVar('sv_lan')) or (usersteamid.lower() == 'steam_id_lan'):
         usersteamid = ('LAN_' + es.createplayerlist(userid)[userid]['address'].split(':')[0].replace('.', ''))
   else:
      usersteamid = ('BOT_' + es.getplayername(userid).upper())
   return usersteamid
   
def TellPlayerTotalDamage(userid):
   userid = int(userid)
   if es.exists('userid', userid) and not es.isbot(userid):
      userlanguage = langlib.getLangAbbreviation(es.getclientvar(userid, 'cl_language'))
      if (userid in players) and (players[userid] > 0):
         TellPlayerMessage(userid, translations('showdamage', {'damages': players[userid]}, userlanguage))
      else:
         TellPlayerMessage(userid, translations('nodamage', None, userlanguage))
   
def TellPlayerMessage(userid, message):
   userid = int(userid)
   if es.exists('userid', userid) and not es.isbot(userid):
      es.tell(userid, '#multi', '#green[' + informations.name + '] #default' + message)
      
# ========================================
#  ÉVÉNEMENTS                            #
# ========================================

def es_map_start(event_var):
   Initialization()
   if int(settings['enable']) and len(database):
      for playersteamid in database:
         if not (datetime.date.today() - database[playersteamid]['datetime']).days >= 7:
            continue
         del(database[playersteamid])
         
def player_spawn(event_var):
   if int(settings['enable']) and (int(event_var['es_userteam']) in [2,
                                                                     3]):
      userid = int(event_var['userid'])
      if not es.isbot(userid):
         usersteamid = GetPlayerSteamID(userid)
         if usersteamid in database:
            database[usersteamid]['datetime'] = datetime.date.today()
            
def player_death(event_var):
   userid = int(event_var['userid'])
   if int(settings['enable']) and userid in players:
      TellPlayerTotalDamage(event_var['userid'])
      
def round_start(event_var):
   if int(settings['enable']) and int(settings['advert']):
      for playerid in es.getUseridList():
         if es.isbot(playerid):
            continue
         TellPlayerMessage(playerid, translations('advert', {'saycmd': str(settings['saycmd']).lower()}, langlib.getLangAbbreviation(es.getclientvar(playerid, 'cl_language'))))
   players.clear()
   
def round_end(event_var):
   if int(settings['enable']):
      for playerid in es.getUseridList():
         if es.getplayerprop(playerid, 'CBasePlayer.pl.deadflag') or es.isbot(playerid):
            continue
         playersteamid = GetPlayerSteamID(playerid)
         if (playersteamid not in database and int(settings['status'])) or (playersteamid in database and database[playersteamid]['status']):
            TellPlayerTotalDamage(playerid)
   players.clear()
   
def player_say(event_var):
   if int(settings['enable']) and (event_var['text'].lower() == str(settings['saycmd']).lower()):
      userid = int(event_var['userid'])
      usersteamid = GetPlayerSteamID(userid)
      if usersteamid not in database:
         database[usersteamid] = {'datetime': datetime.date.today(),
                                  'status'  : (True if int(settings['status']) else False)}
      if not database[usersteamid]['status']:
         database[usersteamid]['status'] = True
      else:
         database[usersteamid]['status'] = False
      TellPlayerMessage(userid, translations(('enable' if database[usersteamid]['status'] else 'disable'), None, langlib.getLangAbbreviation(es.getclientvar(userid, 'cl_language'))))
      
def player_hurt(event_var):
   attackerid = int(event_var['attacker'])
   if es.exists('userid', attackerid) and not es.isbot(attackerid):
      damage = int(event_var['dmg_health'])
      if attackerid not in players:
         players[attackerid] = damage
      else:
         players[attackerid] = (players[attackerid] + damage)
      if int(settings['enable']):
         attackersteamid = GetPlayerSteamID(attackerid)
         if (attackersteamid not in database and int(settings['status'])) or (attackersteamid in database and database[attackersteamid]['status']):
            es.centertell(attackerid, '-' + str(damage) + 'HP')