﻿import es, popuplib, usermsg, gamethread

### ADDON INFO ###
info = es.AddonInfo()
info['name'] = "Undead's Radio"
info['version'] = "5.2"
info['author'] = "Undead"
info['url'] = "http://forums.mattie.info/cs/forums/viewtopic.php?t=23389"
info['description'] = "An Advance Radio System that allows you to listen to live stations while playing!"

es.ServerVar('radio_version', info['version'], 'Undead\'s Radio').makepublic()

### LOADS ###
def load():
    if not es.exists('saycommand', '!radio'):
        es.regsaycmd('!radio', 'radio/radiocmd')
    if not es.exists('saycommand', '!stop'):
        es.regsaycmd('!stop', 'radio/stopcmd')

    Start = popuplib.easymenu('start', '_popup_choice', start_menuselect)
    Start.settitle("Выберите радиостанцию:")
    Start.addoption('1', "Undead\'s Radio")
    Start.addoption('2', "Source Tunes Radio")
    Start.addoption('3', "Выключить радио")

    Genre = popuplib.easymenu('genre', '_popup_choice', genre_menuselect)
    Genre.settitle("Выберите жанр:")
    Genre.addoption('1', "Rock")
    Genre.addoption('2', "Rap/Hip-Hop")
    Genre.addoption('3', "Dance/Techno")
    Genre.addoption('4', "Jazz")
    Genre.addoption('5', "Country")
    Genre.addoption('6', "Oldies")

    ST_Genre = popuplib.easymenu('st_genre', '_popup_choice', st_genre_menuselect)
    ST_Genre.settitle("Выберите Source Tunes жанр:")
    ST_Genre.addoption('1', "Rock")
    ST_Genre.addoption('2', "Rap/RnB/Urban")
    ST_Genre.addoption('3', "Dance/Techno/House")
    ST_Genre.addoption('4', "Blues/Jazz")
    ST_Genre.addoption('5', "Country")
    ST_Genre.addoption('6', "Latino")
    ST_Genre.addoption('7', "Old School/Decades")

    Rock = popuplib.easymenu('rock', '_popup_choice', rock_menuselect)
    Rock.settitle("Выберите Rock Станцию:")
    Rock.addoption('1', "Modern Rock Alternative")
    Rock.addoption('2', "The Buzz - Alt. Rock")
    Rock.addoption('3', "The Arrow - Classic Rock")
    Rock.addoption('4', "Radio Wazee")
    Rock.addoption('5', "WBER 90.5 NY")
    Rock.addoption('6', "High Voltage")
    Rock.addoption('7', "Positive Rock")
    Rock.addoption('8', "96x - Top Rock")

    Rap = popuplib.easymenu('rap', '_popup_choice', rap_menuselect)
    Rap.settitle("Выберите Rap/Hip-Hop Станцию:")
    Rap.addoption('1', "Hot 108 Jamz")
    Rap.addoption('2', "Energy Jamz")
    Rap.addoption('3', "The Beat")
    Rap.addoption('4', "Flow 103")

    Dance = popuplib.easymenu('dance', '_popup_choice', dance_menuselect)
    Dance.settitle("Выберите Dance Станцию:")
    Dance.addoption('1', "Trance")
    Dance.addoption('2', "Party Radio USA")
    Dance.addoption('3', "Chillout Radio")
    Dance.addoption('4', "Energy Club Hits")
    Dance.addoption('5', "Eurodance")

    Jazz = popuplib.easymenu('jazz', '_popup_choice', jazz_menuselect)
    Jazz.settitle("Выберите Jazz Станцию:")
    Jazz.addoption('1', "The Breeze")
    Jazz.addoption('2', "Sky FM Jazz")
    Jazz.addoption('3', "Modern Jazz")

    Country = popuplib.easymenu('country', '_popup_choice', country_menuselect)
    Country.settitle("Выберите Country Станцию:")
    Country.addoption('1', "Sky FM Country")
    Country.addoption('2', "Kickin\' Country")
    Country.addoption('3', "Classic Country")
    Country.addoption('4', "Bluegrass")

    Oldies = popuplib.easymenu('oldies', '_popup_choice', oldies_menuselect)
    Oldies.settitle("Выберите Oldies Станцию:")
    Oldies.addoption('1', "Awesome 80s")
    Oldies.addoption('2', "80s HairBand\'s")
    Oldies.addoption('3', "Star 181 - 90s")
    Oldies.addoption('4', "Great Oldies")

    ST_Rap = popuplib.easymenu('st_rap', '_popup_choice', st_rap_menuselect)
    ST_Rap.settitle("Выберитеt A Rap/RnB/Urban Станцию:")
    ST_Rap.addoption('1', "Old School Rap")
    ST_Rap.addoption('2', "RnB Hits")
    ST_Rap.addoption('3', "Rhythmic Hits")
    ST_Rap.addoption('4', "Skatin\' Jamz")
    ST_Rap.addoption('5', "Great Golden Grooves")
    ST_Rap.addoption('6', "Solid Gold Soul")
    ST_Rap.addoption('7', "Old School Funk")
    ST_Rap.addoption('8', "The Flava - CLEAN")
    ST_Rap.addoption('9', "The Flava - RAW")

    ST_Jazz = popuplib.easymenu('st_jazz', '_popup_choice', st_jazz_menuselect)
    ST_Jazz.settitle("Выберите Jazz Станцию:")
    ST_Jazz.addoption('1', "Bar Rockin\' Blues")
    ST_Jazz.addoption('2', "Big Band Cantina")
    ST_Jazz.addoption('3', "Classic Blues")
    ST_Jazz.addoption('4', "Smooth Jazz")
    ST_Jazz.addoption('5', "Jazz Masters")

    ST_Dance = popuplib.easymenu('st_dance', '_popup_choice', st_dance_menuselect)
    ST_Dance.settitle("Выберите Dance Станцию:")
    ST_Dance.addoption('1', "Dance Hits")
    ST_Dance.addoption('2', "The Beat")
    ST_Dance.addoption('3', "House")
    ST_Dance.addoption('4', "Chicago House Radio")
    ST_Dance.addoption('5', "Trance")
    ST_Dance.addoption('6', "Breakbeat")
    ST_Dance.addoption('7', "Trance and Progressive")
    ST_Dance.addoption('8', "Electric Playground")
    ST_Dance.addoption('9', "Industrial Radio")

    ST_Country = popuplib.easymenu('st_country', '_popup_choice', st_country_menuselect)
    ST_Country.settitle("Выберите Country Станцию:")
    ST_Country.addoption('1', "Hit Kicker Country")
    ST_Country.addoption('2', "Tears N\' Beers Country")
    ST_Country.addoption('3', "Classic Country")
    ST_Country.addoption('4', "Folk Classics")
    ST_Country.addoption('5', "Ladies of Country")
    ST_Country.addoption('6', "Bar Rockin\' Country")

    ST_Oldies = popuplib.easymenu('st_oldies', '_popup_choice', st_oldies_menuselect)
    ST_Oldies.settitle("Выберите Oldies Станцию:")
    ST_Oldies.addoption('1', "Jammin\' Oldies")
    ST_Oldies.addoption('2', "Skatin\' Jamz")
    ST_Oldies.addoption('3', "70s Lite Hits")
    ST_Oldies.addoption('4', "80s Lite Hits")
    ST_Oldies.addoption('5', "80s Hi-NRG Dance")

    ST_Latino = popuplib.easymenu('st_latino', '_popup_choice', st_latino_menuselect)
    ST_Latino.settitle("Выберите Latino Станцию:")
    ST_Latino.addoption('1', "Latino Caliente")
    ST_Latino.addoption('2', "Reggaeton")
    ST_Latino.addoption('3', "Merengue")
    ST_Latino.addoption('4', "Salsa")

    ST_Rock = popuplib.easymenu('st_rock', '_popup_choice', st_rock_menuselect)
    ST_Rock.settitle("Выберите Rock Станцию:")
    ST_Rock.addoption('1', "Hard Rock")
    ST_Rock.addoption('2', "Alternative Rock")
    ST_Rock.addoption('3', "Heavy Metal")
    ST_Rock.addoption('4', "Classic Rock")
    ST_Rock.addoption('5', "Hair Voltage")
    ST_Rock.addoption('6', "Love Bites")
    ST_Rock.addoption('7', "Classic Alternative")
    ST_Rock.addoption('8', "Classic New Wave")

    es.msg('#multi', '#greenRadio #lightgreenby Undead has been loaded!')

def unload():
    if es.exists('saycommand', '!radio'):
        es.unregsaycmd('!radio')
    if es.exists('saycommand', '!stop'):
        es.unregsaycmd('!stop')

    popuplib.delete('start')
    popuplib.delete('genre')
    popuplib.delete('rock')
    popuplib.delete('rap')
    popuplib.delete('dance')
    popuplib.delete('jazz')
    popuplib.delete('country')
    popuplib.delete('oldies')
    popuplib.delete('st_genre')
    popuplib.delete('st_rock')
    popuplib.delete('st_rap')
    popuplib.delete('st_jazz')
    popuplib.delete('st_dance')
    popuplib.delete('st_country')
    popuplib.delete('st_oldies')
    popuplib.delete('st_latino')

    es.msg('#multi', '#greenRadio #lightgreenby Undead has been unloaded!')

### COMMANDS ###
def radiocmd():
    popuplib.send('start', es.getcmduserid())

def stopcmd():
    userid = es.getcmduserid()
    usermsg.showVGUIPanel(userid, 'info', False, {'type':2, 'title':'Stop Radio', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/index.html'})

### POPUP MENUSELECTS ###
def start_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    if choice == '1':
        popuplib.send('genre', userid)
    if choice == '2':
        popuplib.send('st_genre', userid)
    if choice == '3':
        usermsg.showVGUIPanel(userid, 'info', False, {'type':2, 'title':'Stop Radio', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/index.html'})
        es.msg('%s выключил рвдио '%name)

def genre_menuselect (userid, choice, popupid):
    if choice == '1':
        popuplib.send('rock', userid)
    elif choice == '2':
        popuplib.send('rap', userid)
    elif choice == '3':
        popuplib.send('dance', userid)
    elif choice == '4':
        popuplib.send('jazz', userid)
    elif choice == '5':
        popuplib.send('country', userid)
    elif choice == '6':
        popuplib.send('oldies', userid)

def st_genre_menuselect (userid, choice, popupid):
    if choice == '1':
        popuplib.send('st_rock', userid)
    elif choice == '2':
        popuplib.send('st_rap', userid)
    elif choice == '3':
        popuplib.send('st_dance', userid)
    elif choice == '4':
        popuplib.send('st_jazz', userid)
    elif choice == '5':
        popuplib.send('st_country', userid)
    elif choice == '6':
        popuplib.send('st_latino', userid)
    elif choice == '7':
        popuplib.send('st_oldies', userid)

def rock_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Rock'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Modern Rock Alternative', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/modernrock.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Buzz - Alt. Rock', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/altrock.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Arrow - Classic Rock', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/classicrock.html'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Radio Wazee', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/radiowazee.html'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'WBER 90.5 NY', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/wber.html'})
    elif choice == '6':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'High Voltage', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/hardrock.html'})
    elif choice == '7':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Positive Rock', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/positiverock.html'})
    elif choice == '8':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'96x - Top Rock', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/96x.html'})

def rap_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Rap/Hip-Hop'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Hot 108 Jamz', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/hot108jamz.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Energy Jamz', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/energyjamz.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Beat', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/hiphop.html'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Flow 103', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/flow103.html'})

def dance_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Dance/Techno'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Trance', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/dance.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Party Radio USA', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/partyusa.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Chillout Radio', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/chillout.html'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Energy Club Hits', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/energyclub.html'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Eurodance', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/eurodance.html'})

def jazz_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Jazz'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Breeze', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/jazz.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Sky FM Jazz', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/skyfm.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Modern Jazz', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/modernjazz.html'})

def country_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Country'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Sky FM Country', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/country.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Kickin\' Country', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/kickin.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic Country', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/classiccountry.html'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Bluegrass', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/bluegrass.html'})

def oldies_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Oldies'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Awesome 80s', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/awesome80s.html'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'80s HairBand\'s', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/80shairbands.html'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Star 181 - 90s', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/star181.html'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Great Oldies', 'msg':'http://www.s169939360.onlinehome.us/eloric/radio/greatoldies.html'})

def st_rap_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Rap/Hip-Hop'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Old School Rap', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=oldschoolrap'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'RnB Hits', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=rbhits'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Rhythmic Hits', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=rhythmichits'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Skatin\' Jamz', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=skatinjamz'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Great Golden Grooves', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=greatgoldengrooves'})
    elif choice == '6':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Solid Gold Soul', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=solidgoldsoul'})
    elif choice == '7':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Old School Funk', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=oldschoolfunk'})
    elif choice == '8':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Flava - CLEAN', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=thaflavaclean'})
    elif choice == '9':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Flava - RAW', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=thaflavaraw'})

def st_jazz_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Jazz'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Bar Rockin\' Blues', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=barrockinblues'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Big Band Cantina', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=%20bigbandcantina'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic Blues', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=classicblues'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Smooth Jazz', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=smoothjazz'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Jazz Masters', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=jazzmasters'})

def st_dance_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Dance/Techno/House'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Dance Hits', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=dancehitschicago'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'The Beat', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=thebeatmiami'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'House', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=housemiami'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Chicago House Radio', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=chicagohouseradio'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Trance', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=trance'})
    elif choice == '6':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Breakbeat', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=breakbeattampa'})
    elif choice == '7':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Trance and Progressive', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=tranceprogressive'})
    elif choice == '8':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Electronic Playground', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=electronicplayground'})
    elif choice == '9':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Industrial Radio', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=realindustrial'})

def st_country_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Country'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Hit Kicker Country', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=hitkickercountry'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Tears N\' Beers Country', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=tearsnbeerscountry'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic Country', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=classiccountry'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Folk Classics', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=folkclassics'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Ladies of Country', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=ladiesofcountry'})
    elif choice == '6':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Bar Rockin\' Country', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=barrockincountry'})

def st_oldies_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Oldies'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Jammin\' Oldies', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=jamminoldies'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Skatin\' Jamz', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=skatinjamz'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'70s Lite Hits', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=70slitehits'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'80s Lite Hits', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=80slitehits'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'80s Hi-NRG Dance', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=%2080shinrgdance'})

def st_latino_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Latino'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Latino Caliente', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=Latino%20Caliente'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Reggaeton', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=Reggaeton'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Marengue', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=Merengue'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Salsa', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=salsa'})

def st_rock_menuselect (userid, choice, popupid):
    name = es.getplayername(userid)
    es.msg('%s начал слушать Source Tunes Rock'%name)
    if choice == '1':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Hard Rock', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=hardrock'})
    elif choice == '2':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Alternative Rock', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=alternativerock'})
    elif choice == '3':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Heavy Metal', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=&game=&chan=heavymetal'})
    elif choice == '4':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic Rock', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=classicrock'})
    elif choice == '5':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Hair Voltage', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=hairvoltage'})
    elif choice == '6':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Love Bites', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=lovebites'})
    elif choice == '7':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic Alternative', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=classicalternative'})
    elif choice == '8':
        usermsg.showVGUIPanel(userid, 'info', True, {'type':2, 'title':'Classic New Wave', 'msg':'http://www.sourcetunes.com/players/server_player/play.php?id=default&game=&chan=classicnewwave'})

### EVENTS ###
def round_start(ev):
    es.msg('#green', 'Пишите в чате !radio что бы послушать радио, и !stop что бы остановить')