﻿# Music admins - Music admins can force music, force stop and more.
# You can add more admins, just keep the syntax!
MusicAdmins = ["STEAM_0:1:26397964", "STEAM_0:1:7589873", "STEAM_ID_LAN"]

# For more configuration see:
# "../cfg/eventscripts/music/music.cfg"

## No more editing in this script!
import es
import cfglib
import langlib
import popuplib
import playerlib
from usermsg import motd
from urllib2 import urlopen

import psyco
psyco.full()

ReplayArtist = {}
ReplayTrack = {}
ReplayURL = {}
NowPlayingArtist = {}
NowPlayingTrack = {}
NowPlayingURL = {}
MusicForcement = {}
ForceMusicArtist = {}
ForceMusicTrack = {}
ForceMusicURL = {}

variables = [
        ["music_version","v5.0.11CheeTaH-Public","The Music Menu script version.",1],
        ["music_database","cheetah.thekks.net/cheetah_stuff/music/musicdb.html","The Music Menu music database.",1],
        ["music_show_motd", "1", "If this is enabled, then the MOTD will show when a song is chosen",0],
        ["music_adverts", "1", "If this is enabled, then an advert will be sent at 'every now and then'",0],
        ["music_only_for_dead", "0", "If this is enabled, then only dead people can play music!'",0],
        ["music_only_for_admin", "0", "If this is enabled, then only admins can play music. Unless a person is forced!'",0],
        ["music_print_added_artists", "1", "If this is enabled, then on script load, it will print out all the artists!'",0],
        ["music_print_added_radios", "1", "If this is enabled, then on script load, it will print out all the radios!'",0],
    ]

ConsoleCMDs = ["!musicshow", "!music", "!stop", "!replay", "!nowplaying", "!musicforce", "!musicforceall",
        "!musicforceperson", "!musicbrowse", "!musicpanel", "!musicjoin", "!radio", "!musicshowabc",]
SayCMDs = ["!musicbrowse"]


ini = cfglib.AddonINI(es.getAddonPath("music") + '/translations.ini')
translations = langlib.Strings(ini)

def load():
    MMinfo()
    MMmenu()
    if (es.ServerVar("music_adverts")):
        MusicTell("all", "Has been loaded [%s]" %(es.ServerVar("music_version")))
    for CMD in SayCMDs:
        block = "music/client_cmd_%s" %(str(CMD).replace("!", ""))
        es.regsaycmd(CMD, block, "Client Say Command")
    for CMD in ConsoleCMDs:
        block = "music/client_cmd_%s" %(str(CMD).replace("!", ""))
        es.regclientcmd(CMD, block, "Client Say Command")
    
    global MusicForceMenu
    MusicForceMenu = popuplib.easymenu("MusicForceMenu",None,MusicForceSelection)
    MusicForceMenu.settitle("Forcing Method:")
    MusicForceMenu.addoption("!music", "Force me (!Music)")
    MusicForceMenu.addoption("!musicforceall", "Force all (!MusicForceAll)")
    MusicForceMenu.addoption("!musicforceperson", "Force person (!MusicForcePerson)")
    
    global music_method
    music_method = popuplib.easymenu("music_method",None,MusicForceSelection)
    music_method.settitle("Choose A Method:")
    music_method.addoption("!musicshow", "View a list of songs")
    music_method.addoption("!musicshowabc", "View a list of songs [ABC-DEF-....]")
    music_method.addoption("!musicbrowse youtube.com", "Search on Youtube")
    # music_method.addoption("!musicbrowse grooveshark.com", "Search on GrooveShark")
    
    global musicmenu_panel
    musicmenu_panel = popuplib.easymenu("musicmenu_panel",None,MusicForceSelection)
    musicmenu_panel.settitle("Music Panel:")
    musicmenu_panel.addoption("!stop", "Stop Music")
    musicmenu_panel.addoption("!music", "Play Music")
    musicmenu_panel.addoption("!radio", "Listen to radio")
    musicmenu_panel.addoption("!replay", "Replay a song")
    musicmenu_panel.addoption("!nowplaying", "Nowplaying menu")
    musicmenu_panel.addoption("!musicjoin", "Join another players song")
    musicmenu_panel.addoption("!musicforce", "Force a song")
    musicmenu_panel.addoption("!musicforcestop", "Force stop")
    
    global musicmenu_nowplaying
    musicmenu_nowplaying = popuplib.easymenu("musicmenu_nowplaying",None,NowPlayingBlock)
    musicmenu_nowplaying.settitle("Music Panel:")
    musicmenu_nowplaying.addoption("!NowPlayingTellAll", "Tell all what I listen to")
    musicmenu_nowplaying.addoption("!NowPlayingTellMeI", "Tell me what I listen to")
    musicmenu_nowplaying.addoption("!NowPlayingTellMe", "Tell me what other listen to [include not-listening-people]")
    musicmenu_nowplaying.addoption("!NowPlayingTellMeN", "Tell me what other listen to [don't include not-listening-people]")
    
def unload():
    if (es.ServerVar("music_adverts")):
        MusicTell("all", "Has been unloaded [%s]" %(es.ServerVar("music_version")))
    for CMD in SayCMDs:
        es.unregsaycmd(CMD)
    for CMD in ConsoleCMDs:
        es.unregclientcmd(CMD)
                    
def es_map_start(ev):
    MMinfo()
    MMmenu()
    
def player_say(ev):
    text = str(ev["text"]).lower()
    userid = int(ev["userid"])
    if (text in ConsoleCMDs): es.cexec(userid, text)
    
def round_end(ev):
    if (es.ServerVar("music_adverts")):
        MusicTell("all", "is enabled. Type #green!music #defaultto see a list of songs. Type #green!stop#default to stop the music!")

def player_disconnect(ev):
    userid = int(ev['userid'])
    if userid in ReplayArtist:
        del ReplayArtist[userid]
        del ReplayTrack[userid]
        del ReplayURL[userid]
    if userid in NowPlayingArtist:
        del NowPlayingArtist[userid]
        del NowPlayingTrack[userid]
        del NowPlayingURL[userid]
    if userid in MusicForcement:
        del MusicForcement[userid]
    if userid in ForceMusicArtist:
        del ForceMusicArtist[userid]
        del ForceMusicTrack[userid]
        del ForceMusicURL[userid]
        
def MusicForceSelection(userid,choice,popupname):
    es.cexec(userid, choice)
    
def MusicSendSelection(userid,choice,popupname):
    popuplib.send(choice,userid)

def Lang(userid):
    return playerlib.getPlayer(userid).lang

def IsDead(player):
    playerp = playerlib.getPlayer(int(player))
    if (es.ServerVar("music_only_for_dead")):
        return playerp.isdead
    else:
        return 1

def MusicJoinBlock(userid,choice,popupname):
    if choice in NowPlayingArtist:
        MusicTell(userid, "You joined %ss song:" %(es.getplayername(choice)))
        MusicTell(choice, "%s joined your song:" %(es.getplayername(userid)))
        MusicTellSong(userid, NowPlayingArtist[choice], NowPlayingTrack[choice])
        MusicTellSong(choice, NowPlayingArtist[choice], NowPlayingTrack[choice])
        ReplayArtist[userid] = ReplayArtist[choice]
        ReplayTrack[userid] = ReplayTrack[choice]
        ReplayURL[userid] = ReplayURL[choice]
        NowPlayingURL[userid] = NowPlayingURL[choice]
        NowPlayingArtist[userid] = NowPlayingArtist[choice]
        NowPlayingTrack[userid] = NowPlayingTrack[choice]
        playURL(userid, NowPlayingURL[choice])
    else:
        MusicTell(userid, "%s isn't listening to anything!" %(es.getplayername(choice)))
    
def playURL(userid,URL,forceMOTD=0): # plays a URL
    motd(userid,2,"CheeTaH - Music Menu %s"%es.ServerVar("music_version"),"about:blank",False)
    if (URL.lower() != "stop"):
        if (es.ServerVar("music_show_motd")): Show = True
        if not (es.ServerVar("music_show_motd")): Show = False
        if (forceMOTD): Show = True
        motd(userid,2,"CheeTaH - Music Menu %s"%es.ServerVar("music_version"),URL,Show)

def MenuFix(Menu):
    Menu = str(Menu).lower().replace("&","").replace(" ","").replace("-","").replace("_","").replace("!","").replace("'","").replace("/","")
    Menu = str(Menu).replace(".","").replace(",","").replace("[","").replace("]","").replace("(","").replace(")","").replace("$","s")
    return Menu
        
def MusicTell(TellPerson, Message, MusicPrefix=1):
    if (MusicPrefix): Message2 = "\x05[Music] #default%s" %(Message)
    if not (MusicPrefix): Message2 = "#default%s" %(Message)
    if (str(TellPerson).lower() != "all"):
        if not es.exists('userid', TellPerson): return
        es.tell(TellPerson, "#multi", Message2)
    else:
        es.msg("#multi", Message2)
    
def MusicTellSong(TellPerson, artist, track):
    TellMSG = "\x05%s#default - \x05%s" %(artist, track)
    if (str(TellPerson).lower() != "all"):
        if not es.exists('userid', TellPerson): return
        es.tell(TellPerson, "#multi", TellMSG)
    else:
        es.msg("#multi", TellMSG)
    
def MusicTellRadio(TellPerson, radio):
    TellMSG = "\x05%s" %(radio)
    if (str(TellPerson).lower() != "all"):
        if not es.exists('userid', TellPerson): return
        es.tell(TellPerson, "#multi", TellMSG)
    else:
        es.msg("#multi", TellMSG)
    
def PlayerIsMusicAdmin(userid):
    if not es.exists('userid', userid):
        return False
    steamid = es.getplayersteamid(userid)
    if steamid in MusicAdmins:
        return True
    return False
    
def NowPlayingBlock(userid,choice,popupname):
    if (choice == "!NowPlayingTellAll"): # Tell all what I listen to
        if userid in NowPlayingArtist:
            MusicTell("all", "%s is currently listening to:" %(es.getplayername(userid)))
            MusicTellSong("all", NowPlayingArtist[userid], NowPlayingTrack[userid])
        else:
            MusicTell("all", "%s is currently not listening to anything!" %(es.getplayername(userid)))
    elif (choice == "!NowPlayingTellMeI"): # Tell me what I listen to
        if userid in NowPlayingArtist:
            MusicTell(userid, translations('music_now_playing_msg', None, Lang(userid)))
            MusicTellSong(userid, NowPlayingArtist[userid], NowPlayingTrack[userid])
        else:
            MusicTell(userid, translations('music_now_playing_msg_nothing', None, Lang(userid)))
    elif (choice == "!NowPlayingTellMe"): # Tell me what other listen to [include not-listening-people]
        es.cexec(userid, "echo ----------------")
        es.cexec(userid, "echo Now Playing:")
        es.cexec(userid, "echo ----------------")
        MusicTell(userid, "Please check your console!")
        Players = playerlib.getUseridList('#human')
        for Player in Players:
            if Player in NowPlayingArtist:
                es.cexec(userid, "echo Player..: %s" %(str(es.getplayername(Player))))
                es.cexec(userid, "echo Artist..: %s" %(str(NowPlayingArtist[Player])))
                es.cexec(userid, "echo Track...: %s" %(str(NowPlayingTrack[Player])))
                es.cexec(userid, "echo URL.....: %s" %(str(NowPlayingURL[Player])))
            else:
                es.cexec(userid, "echo %s Is not listening to anything!" %(str(es.getplayername(Player))))
            es.cexec(userid, "echo ----------------")
    elif (choice == "!NowPlayingTellMeN"): # Tell me what other listen to [don't include not-listening-people]
        MusicTell(userid, "Please check your console!")
        MusicPeopleFound = 0
        es.cexec(userid, "echo ----------------")
        es.cexec(userid, "echo Now Playing:")
        es.cexec(userid, "echo ----------------")
        Players = playerlib.getUseridList('#human')
        for Player in Players:
            if Player in NowPlayingArtist:
                MusicPeopleFound += 1
                es.cexec(userid, "echo Player..: %s" %(str(es.getplayername(Player))))
                es.cexec(userid, "echo Artist..: %s" %(str(NowPlayingArtist[Player])))
                es.cexec(userid, "echo Track...: %s" %(str(NowPlayingTrack[Player])))
                es.cexec(userid, "echo URL.....: %s" %(str(NowPlayingURL[Player])))
                es.cexec(userid, "echo ----------------")
        if (MusicPeopleFound == 0):
            es.cexec(userid, "echo No players found!!")
            es.cexec(userid, "echo ----------------")
    
def MusicForcePersonBlock(userid,choice,popupname):
    if (choice != "UpdateList"):
        MusicTell(userid, translations('music_forced_forcer', {'ForcedName':es.getplayername(choice)}, Lang(userid)))
        MusicTell(choice, translations('music_forced_forced', {'ForcerName':es.getplayername(userid)}, Lang(choice)))
        for Player in playerlib.getUseridList('#human'):
            if (Player != userid):
                if (Player != choice):
                    MusicTell(userid, translations('music_forced_others', {'ForcerName':es.getplayername(userid),'ForcedName':es.getplayername(choice)}, Lang(Player)))
        MusicTellSong("all", ForceMusicArtist[userid], ForceMusicTrack[userid])
        playURL(choice, ForceMusicURL[userid])
    CreateForceMenu(userid, ForceMusicURL[userid], ForceMusicArtist[userid], ForceMusicTrack[userid])
    
def CreateForceMenu(Player, URL, Artist, Track):
    ForceMusicArtist[Player] = Artist
    ForceMusicTrack[Player] = Track
    ForceMusicURL[Player] = URL
    if popuplib.exists('MusicForcePersonMenu'): popuplib.delete('MusicForcePersonMenu')
    global MusicForcePersonMenu
    MusicForcePersonMenu = popuplib.easymenu('MusicForcePersonMenu',None, MusicForcePersonBlock)
    MusicForcePersonMenu.settitle("Music %s" %str(es.ServerVar("music_version")).replace("CheeTaH-Public", "").replace("v", ""))
    MusicForcePersonMenu.setdescription("Choose a player to force to: \n%s - %s \n%s" %(Artist, Track, URL))
    MusicForcePersonMenu.addoption('UpdateList', '--- Update List ---')
    Players = playerlib.getUseridList('#all')
    Players = sorted(Players, key=lambda player: es.getplayername(player))
    if (Players): MusicForcePersonMenu.addoption('----------', ' ', 0)
    if not (Players): MusicForcePersonMenu.addoption('----------', 'No players found', 0)
    for Player in Players: MusicForcePersonMenu.addoption(Player, '%s (%s)' %(es.getplayername(Player), Player))
    MusicForcePersonMenu.send(Player)
    
    ##############################
    ## MusicMaster Definations! ##
    ##############################
    
def MMmenuhandle(userid,choice,popupname): # when an artist is picked
    MMmusicmenu(choice)
    popuplib.send("musicmenu_artist_%s"%choice,userid)

def MMinfo(): # runs on script load and map change
    global musicDB
    for var in variables:
        vari = es.ServerVar(var[0],var[1],var[2])
        vari.set(var[1])
        if (var[3] == 1): vari.makepublic()
    es.mexec("../cfg/eventscripts/music/music.cfg")
    musicDB = urlopen(str("http://%s"%es.ServerVar("music_database"))).read().replace("\r","").split("\n")
        
def MMmenu(): # runs on script load and map change
    musicartist = popuplib.easymenu("musicmenu_artist_select",None,MMmenuhandle)
    musicartist.settitle("Artist Selection")
    musicartist.submenu(0,"music_method")
    musicmenu_artist_select_abc = popuplib.easymenu("musicmenu_artist_select_abc",None,MusicSendSelection)
    musicmenu_artist_select_abc.settitle("Artist Selection")
    musicmenu_artist_select_abc.submenu(0,"music_method")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_spe","Specials")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_abc","ABC")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_def","DEF")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_ghi","GHI")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_jkl","JKL")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_mno","MNO")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_pqr","PQR")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_stu","STU")
    musicmenu_artist_select_abc.addoption("musicmenu_starts_vwxyz","VWXYZ")
    musicmenu_starts_spe = popuplib.easymenu("musicmenu_starts_spe",None,MMmenuhandle)
    musicmenu_starts_spe.settitle("Artist Selection")
    musicmenu_starts_spe.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_spe.setdescription("Special characters")
    musicmenu_starts_abc = popuplib.easymenu("musicmenu_starts_abc",None,MMmenuhandle)
    musicmenu_starts_abc.settitle("Artist Selection")
    musicmenu_starts_abc.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_abc.setdescription("ABC")
    musicmenu_starts_def = popuplib.easymenu("musicmenu_starts_def",None,MMmenuhandle)
    musicmenu_starts_def.settitle("Artist Selection")
    musicmenu_starts_def.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_def.setdescription("DEF")
    musicmenu_starts_ghi = popuplib.easymenu("musicmenu_starts_ghi",None,MMmenuhandle)
    musicmenu_starts_ghi.settitle("Artist Selection")
    musicmenu_starts_ghi.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_ghi.setdescription("GHI")
    musicmenu_starts_jkl = popuplib.easymenu("musicmenu_starts_jkl",None,MMmenuhandle)
    musicmenu_starts_jkl.settitle("Artist Selection")
    musicmenu_starts_jkl.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_jkl.setdescription("JKL")
    musicmenu_starts_mno = popuplib.easymenu("musicmenu_starts_mno",None,MMmenuhandle)
    musicmenu_starts_mno.settitle("Artist Selection")
    musicmenu_starts_mno.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_mno.setdescription("MNO")
    musicmenu_starts_pqr = popuplib.easymenu("musicmenu_starts_pqr",None,MMmenuhandle)
    musicmenu_starts_pqr.settitle("Artist Selection")
    musicmenu_starts_pqr.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_pqr.setdescription("PQR")
    musicmenu_starts_stu = popuplib.easymenu("musicmenu_starts_stu",None,MMmenuhandle)
    musicmenu_starts_stu.settitle("Artist Selection")
    musicmenu_starts_stu.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_stu.setdescription("STU")
    musicmenu_starts_vwxyz = popuplib.easymenu("musicmenu_starts_vwxyz",None,MMmenuhandle)
    musicmenu_starts_vwxyz.settitle("Artist Selection")
    musicmenu_starts_vwxyz.submenu(0,"musicmenu_artist_select_abc")
    musicmenu_starts_vwxyz.setdescription("VWXYZ")
    radiomenu = popuplib.easymenu("musicmenu_radio_select",None,MMradiohandle)
    radiomenu.settitle("Radio Selection")
    
    ArtistUsed = {}
    Radios = {}
    for artists in musicDB:
        if (str(artists).lower().startswith("www.") or str(artists).lower().startswith("http://")):
            artist = artists.split("|")
            if (len(artist) == 3):
                Artist = artist[1]
                if Artist not in ArtistUsed: ArtistUsed[Artist] = Artist
        elif str(artists).lower().startswith("radio|"):
            artist = artists.split("|")
            if (len(artist) == 3): Radios[artist[2]] = artist
    
    number = 0
    for title in sorted(ArtistUsed.keys()):
        musicartist.addoption(title,title)
        if (str(title).lower().startswith(("a","b","c"))): musicmenu_starts_abc.addoption(title,title)
        elif (str(title).lower().startswith(("d","e","f"))): musicmenu_starts_def.addoption(title,title)
        elif (str(title).lower().startswith(("g","h","i"))): musicmenu_starts_ghi.addoption(title,title)
        elif (str(title).lower().startswith(("j","k","l"))): musicmenu_starts_jkl.addoption(title,title)
        elif (str(title).lower().startswith(("m","n","o"))): musicmenu_starts_mno.addoption(title,title)
        elif (str(title).lower().startswith(("p","q","r"))): musicmenu_starts_pqr.addoption(title,title)
        elif (str(title).lower().startswith(("s","t","u"))): musicmenu_starts_stu.addoption(title,title)
        elif (str(title).lower().startswith(("v","w","x","y","z"))): musicmenu_starts_vwxyz.addoption(title,title)
        else: musicmenu_starts_spe.addoption(title,title)
        if (es.ServerVar("music_print_added_artists")):
            number += 1
            print "Artist: %03d> %s" %(number, title)
          
    number = 0
    for title in sorted(Radios.keys()):
        radiomenu.addoption(Radios[title],title)
        if (es.ServerVar("music_print_added_radios")):
            number += 1
            print "Radio : %03d> %s" %(number, title)
                        
def MMmusicmenu(artist): # put the songs in the artists menu (runs when an artist is picked (MMmenuhandle()))
    musicsong = popuplib.easymenu("musicmenu_artist_%s"%artist,None,MMartisthandle)
    musicsong.settitle("Song Selection: \n %s" %(artist))
    ArtistSongs = {}
    for song in musicDB:
        songi = song.split("|")
        if (len(songi) == 3):
            if (songi[1] == artist):
                ArtistSongs[songi[2]] = songi
    
    for title in sorted(ArtistSongs.keys()):
        musicsong.addoption(ArtistSongs[title],title)
    musicsong.submenu(0,"musicmenu_artist_select")
    
def MMartisthandle(userid,choice,popupname): # when a song is picked
    userid = int(userid)
    if userid not in MusicForcement: MusicForcement[userid] = 0
    if not (PlayerIsMusicAdmin(userid)): MusicForcement[userid] = 0
    MusicForcementValue = MusicForcement[userid]
    if (MusicForcementValue == 0):
        ReplayArtist[userid] = choice[1]
        ReplayTrack[userid] = choice[2]
        ReplayURL[userid] = choice[0]
        MusicTell(userid, translations('music_listening', None, Lang(userid)))
        MusicTellSong(userid, choice[1], choice[2])
        playURL(userid, choice[0])
        NowPlayingURL[userid] = choice[0]
        NowPlayingArtist[userid] = choice[1]
        NowPlayingTrack[userid] = choice[2]
    elif (MusicForcementValue == 1):
        ReplayArtist[userid] = choice[1]
        ReplayTrack[userid] = choice[2]
        ReplayURL[userid] = choice[0]
        for Player in playerlib.getUseridList('#human'):
            MusicTell(Player, translations('music_forced_all', {'ForcerName':es.getplayername(userid)}, Lang(Player)))
        MusicTellSong("all", choice[1], choice[2])
        Players = playerlib.getUseridList('#human')
        for Player in Players:
            playURL(Player, choice[0])
            NowPlayingURL[Player] = choice[0]
            NowPlayingArtist[Player] = choice[1]
            NowPlayingTrack[Player] = choice[2]
    elif (MusicForcementValue == 2): CreateForceMenu(userid, choice[0], choice[1], choice[2])
    
def MMradiohandle(userid,choice,popupname): # when a song is picked
    userid = int(userid)
    MusicTell(userid, translations('music_listening_radio', None, Lang(userid)))
    MusicTellRadio(userid, choice[2])
    playURL(userid, choice[1])
    
    ##############################
    ## Console and Say commands ##
    ##############################
    
def client_cmd_music():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        popuplib.send("music_method",player)
        MusicForcement[player] = 0
    
def client_cmd_musicshow():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        popuplib.send("musicmenu_artist_select",player)
        MusicForcement[player] = 0

def client_cmd_stop():
    player = int(es.getcmduserid())
    playURL(player, "stop")
    MusicTell(player, translations('music_stopped_msg', None, Lang(player)))
    if player in NowPlayingURL:
        del NowPlayingURL[player]
        del NowPlayingArtist[player]
        del NowPlayingTrack[player]

def client_cmd_nowplaying():
    player = int(es.getcmduserid())
    popuplib.send("musicmenu_nowplaying",player)

def client_cmd_replay():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        if player in ReplayArtist:
            MusicTell(player, translations('music_replaying_msg', None, Lang(player)))
            MusicTellSong(player, ReplayArtist[player], ReplayTrack[player])
            NowPlayingURL[player] = ReplayURL[player]
            NowPlayingArtist[player] = ReplayArtist[player]
            NowPlayingTrack[player] = ReplayTrack[player]
            playURL(player, ReplayURL[player])
        else:
            MusicTell(player, translations('music_replaying_msg_unavailable', None, Lang(player)))

def client_cmd_musicforce():
    player = int(es.getcmduserid())
    if (PlayerIsMusicAdmin(player)):
        MusicForceMenu.send(player)
    else:
        MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))

def client_cmd_musicforceall():
    player = int(es.getcmduserid())
    if (PlayerIsMusicAdmin(player)):
        popuplib.send("musicmenu_artist_select",player)
        MusicForcement[player] = 1
    else:
        MusicForcement[player] = 0
        MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))

def client_cmd_musicforceperson():
    player = int(es.getcmduserid())
    if (PlayerIsMusicAdmin(player)):
        popuplib.send("musicmenu_artist_select",player)
        MusicForcement[player] = 2
    else:
        MusicForcement[player] = 0
        MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))

def client_cmd_musicbrowse():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        args = str(es.getargs())
        if ("." in args):
            playURL(player, args, 1)
        else:
            MusicTell(player, "!MusicBrowse <website>")
            MusicTell(player, "ex: '!MusicBrowse www.youtube.com', would send you to: http://www.youtube.com/")

def client_cmd_musicpanel():
    player = int(es.getcmduserid())
    popuplib.send("musicmenu_panel",player)

def client_cmd_musicjoin():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        if popuplib.exists('musicmenu_musicjoin'): popuplib.delete('musicmenu_musicjoin')
        global musicmenu_musicjoin
        musicmenu_musicjoin = popuplib.easymenu("musicmenu_musicjoin",None,MusicJoinBlock)
        musicmenu_musicjoin.settitle("Music Join:")
        Players = playerlib.getUseridList('#all')
        for Player in Players:
            if Player in NowPlayingArtist:
                musicmenu_musicjoin.addoption(Player, "Player: %s" %(str(es.getplayername(Player))))
                musicmenu_musicjoin.addoption(Player, "Artist: %s" %(str(NowPlayingArtist[Player])))
                musicmenu_musicjoin.addoption(Player, "Track : %s" %(str(NowPlayingTrack[Player])))
            else:
                musicmenu_musicjoin.addoption(Player, "Player: %s" %(str(es.getplayername(Player))), 0)
                musicmenu_musicjoin.addoption(Player, "Artist: None", 0)
                musicmenu_musicjoin.addoption(Player, "Track : None", 0)
            musicmenu_musicjoin.addoption(0, " ", 0)
            musicmenu_musicjoin.addoption(0, " ", 0)
            musicmenu_musicjoin.addoption(0, " ", 0)
            musicmenu_musicjoin.addoption(0, " ", 0)
        musicmenu_musicjoin.send(player)
    
def client_cmd_radio():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        popuplib.send("musicmenu_radio_select",player)

def client_cmd_musicshowabc():
    player = int(es.getcmduserid())
    if not (IsDead(player)):
        MusicTell(player, translations('music_only_for_dead_msg', None, Lang(player)))
    else:
        if (es.ServerVar("music_only_for_admin")):
            if not (PlayerIsMusicAdmin(player)):
                MusicTell(player, translations('music_not_admin_msg', None, Lang(player)))
                return
        popuplib.send("musicmenu_artist_select_abc",player)
        MusicForcement[player] = 0