﻿# Name:        CTrun v1.3
#
# Author:      JoeyT2008
#
# Description: Allows CT's to pick up the bomb and run away.
#
# Bugs:        1. CT's can't drop the bomb the first time, they need to drop it twice. After that it will work fine.
#
# Credits:     Creator         JoeyT2008
#
#              Idea            SuperDave
#
#              Thanks          R`SiN
#                              GODJonez
#                              Errant
#                              Einlanzers
#                              Sniperhmm
#                              Venjax

import es, playerlib, gamethread, vecmath, random

holders = {}
immune = []

####SETTINGS####
ctrun_allow_plant = es.ServerVar("ctrun_allow_plant", "0", "Allow CT's to plant the bomb?")
ctrun_lost = es.ServerVar("ctrun_lost", "1", "Return the bomb if it gets lost?")
ctrun_lost_timer = es.ServerVar("ctrun_lost_timer", "30", "How long before the bomb is returned.")
################

info = es.AddonInfo()
info.name = "CTrun"
info.version = "1.3"
info.author = "JoeyT2008"
info.url = "http://forums.mattie.info/cs/forums/viewtopic.php?p=162585"
info.description = "Allows CT's to pick up the bomb and run away."
info.basename = "ctrun"

es.ServerVar("ctrun_ver", info.version, "Version of CTrun that you are using.").makepublic()

def load():
    C4Check()

def unload():
    gamethread.cancelDelayed("C4Check")
    gamethread.cancelDelayed("LostBomb")


def round_end(event_var):
    gamethread.cancelDelayed("LostBomb")
    for userid in holders:
        es.setplayerprop(userid, "CBaseEntity.m_iTeamNum", 3)

def bomb_dropped(event_var):
    Immune(event_var["userid"], 1)
    if ctrun_lost == 1:
        gamethread.delayedname(ctrun_lost_timer, "LostBomb", LostBomb)

def bomb_pickup(event_var):
    gamethread.cancelDelayed("LostBomb")
    Immune(event_var["userid"], 0)

def bomb_beginplant(event_var):
    if ctrun_allow_plant == 0:
        if es.getplayerteam(event_var["userid"]) == 3:
            PickupC4(event_var["userid"], playerlib.getPlayer(event_var["userid"]).get("weaponindex", "weapon_c4"), 1)
            es.tell(event_var["userid"], "#multi", "#green[CTrun]#default Вам нельзя заложить #lightgreenбомбу#default.")

def C4Check():
    c4list = es.createentitylist("weapon_c4")
    if len(c4list) > 0:
        droppedc4 = []
        for c4 in c4list:
            if es.getindexprop(c4, "CBaseEntity.m_hOwnerEntity") == -1:
                droppedc4.append(c4)
            for userid in playerlib.getUseridList("#ct"):
                if not playerlib.getPlayer(userid).get("isdead"):
                    for c4 in droppedc4:
                        if vecmath.distance(es.getindexprop(c4, "CBaseEntity.m_vecOrigin"), es.getplayerprop(userid, "CBaseEntity.m_vecOrigin")) <= 75:
                            PickupC4(userid, c4)
    gamethread.delayedname(0.1, "C4Check", C4Check)

def PickupC4(userid, c4, force = 0):
    if (playerlib.getPlayer(userid).get("weaponindex", "weapon_c4") == 0 and not str(userid) in immune and es.getindexprop(c4, "CBaseEntity.m_hOwnerEntity") == -1) or force == 1:
        es.setplayerprop(userid, "CBaseEntity.m_iTeamNum", 2)
        es.server.cmd("es_remove %s" % c4)
        es.server.cmd("es_give %s weapon_c4" % userid)
        c4 = es.ServerVar("eventscripts_lastgive")
        es.setplayerprop(userid, "CBaseEntity.m_iTeamNum", 3)
        holders[userid] = c4

def Immune(userid, toggle):
    global immune
    if es.getplayerteam(userid) == 3:
        if toggle == 1:
            immune.append(str(userid))
            gamethread.delayed(2.5, Immune, (userid, 0))
        else:
            num = -1
            for checkid in immune:
                num += 1
                if checkid == str(userid):
                    break
            if num < len(immune) and not num == -1:
                if immune[num] == str(userid):
                    del immune[num]

def LostBomb():
    droppedc4 = []
    c4list = es.createentitylist("weapon_c4")
    if len(c4list) > 0:
        droppedc4 = []
        for c4 in c4list:
            if es.getindexprop(c4, "CBaseEntity.m_hOwnerEntity") == -1:
                droppedc4.append(c4)
            else:
                droppedc4 = []
                break
        if len(droppedc4) > 0:
            c4 = random.choice(droppedc4)
            playerlist = []
            for userid in playerlib.getUseridList("#alive"):
                if playerlib.getPlayer(userid).get("weaponindex", "weapon_c4") == 0 and not str(userid) in immune:
                    playerlist.append(userid)
            if len(playerlist) > 0:
                userid = random.choice(playerlist)
                es.msg("#multi", "#green[CTrun]#lightgreenБомба#default была потеряна" % es.getplayername(userid))
                if es.getplayerteam(userid) == 3:
                    PickupC4(userid, c4)
                if es.getplayerteam(userid) == 2:
                    es.server.cmd("es_remove %s" % c4)
                    es.server.cmd("es_give %s weapon_c4" % userid)