import es

# Put your RCON password here. Don't worry, its safe as houses!
rcon_password = ''

# Set to 1 to make rcon_lock announce to chat when rcon has been reset
message = 0

# Set to 1 to protect sv_cheats as well - changes it back to 0 when changed.
protect_cheats = 1

### DO NOT EDIT BELOW THIS LINE ###

info = es.AddonInfo()
info.name        = 'Rcon_lock'
info.version     = '1.5'
info.author      = 'Carbon-14'
info.basename    = 'rcon_lock'
info.description = 'Protects your RCON password from hackers'

def load():
    es.set('rcon_lock',info.version)
    es.makepublic('rcon_lock')
    
    protect_var = es.ServerVar('eventscripts_protectrcon')
    if not protect_var == '1':
        es.log('[RCON LOCK] eventscripts_protectrcon set to 1')
        protect_var.set('1')
        
    es.flags('add','notify','rcon_password')
    es.flags('remove','replicated','rcon_password')

    es.flags('add','notify','eventscripts_protectrcon')
    
    # Check the rcon_password to make sure
    if not es.ServerVar('rcon_password') == rcon_password:
        es.log('[RCON LOCK] The rcon password does not match the one in the script')
        es.log('[RCON LOCK] Changing it back')
        es.set('rcon_password',rcon_password)
        
    es.log('[RCON LOCK] Has been loaded')

def server_cvar(ev):
    if ev['cvarname'] == 'eventscripts_protectrcon':
        es.forcevalue('eventscripts_protectrcon','1')
        
    if ev['cvarname'] == 'rcon_password':
        es.forcevalue('rcon_password',rcon_password)
        if message: es.msg('#multi','#lightgreen[RCON LOCK]#default The rcon password has been reset')
        es.log('--------------------------------------------------')
        es.log('[RCON LOCK] The rcon password was changed')
        es.log('[RCON LOCK] It has been changed back')
        es.log('--------------------------------------------------')
    if ev['cvarname'] == 'sv_cheats':
        if protect_cheats:
            es.forcevalue('sv_cheats','0')
            es.log('[RCON LOCK] sv_cheats has been reset to 0')

def unload():
    es.log('[RCON LOCK] Was unloaded. Re-loading')
    es.ServerCommand('es_xdelayed 0 es_load rcon_lock')
