/*
	[STB] Save Temporary Bans
	Store bans by steamID which includes a time limit, not permanent bans.

	When server re-boot/quit/crash, temporary bans disapear from server memory,
	plugin re-bans from SourceMod SQLite-database where it have store and the right of the remaining time.

	Database file ...addons/sourcemod/data/sqlite/stb-sqlite.sq3
	Table "stb" with (steamid TEXT PRIMARY KEY, duration, timestamp, name, admin, reason, date) fields

	26.12.2010 Version 0.3
	- Re-write whole shit, now it (should) save all temp bans by steamid and timelimit
	everytime when event server_addban and unban command "removeid" happens.
	- Save only info "admin", "reason" in database when ban added by SM plugins, other server/plugins bans are "console"
	- Now sm_stb_list show only 5 bans at time, show next bans need type number, sm_stb_list 5, sm_stb_list 10, sm_stb_list 15 etc. etc.
	- When add permanent ban, plugin also delete steamid with data from db if exist
	- Cvar stb_printrejected 0/1 will print in chat to all banned player with timeleft when banned player try connect server.
	
	27.12.2010 Version 0.4
	- Fu*k, horrible way executebans and check+save them when stb_rejectmode 0
	- I change that hole thing behind 5 seconds timers when plugin loaded first time.
	- Forget add event server_removeban, added
*/

#include <sourcemod>

#define PLUGIN_VERSION "0.4"

public Plugin:myinfo =
{
	name = "[STB] Save Temporary Bans",
	author = "Bacardi",
	description = "Store temporary bans and re-bans after server reboot",
	version = PLUGIN_VERSION,
	url = "www.sourcemod.net"
};

new Handle:stb_rejectmode = INVALID_HANDLE;
new Handle:stb_printrejected = INVALID_HANDLE;
new bool:block = false;	// Helper to block plugin bans

#include "stbinc\event_addban.sp"
#include "stbinc\event_removeban.sp"
#include "stbinc\cmd_removeid.sp"
#include "stbinc\sqlite_save.sp"
#include "stbinc\sqlite_check.sp"
#include "stbinc\event_smbans.sp"
#include "stbinc\cmd_stb_list.sp"
#include "stbinc\executebans.sp"

public OnPluginStart()
{
	// Create cvars
	CreateConVar("stb_version", PLUGIN_VERSION, "Plugin [STB] current version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY|FCVAR_DONTRECORD);
	stb_rejectmode = CreateConVar("stb_rejectmode", "1", "Reject mode\n0 = leave normal ban\n1 = Kick with ban time left message\n2 = Ban IP 1 minute with ban time left message", 0, true, 0.0, true, 2.0);
	stb_printrejected = CreateConVar("stb_printrejected", "0", "Print in chat to all banned connections", 0, true, 0.0, true, 1.0);

	// Create commands
	RegAdminCmd("sm_stb_list", PrintList, ADMFLAG_BAN, "Print list temporary bans from [STB] to console");

	// Hook
	HookEvent("server_addban", Event_server_addban, EventHookMode_Post);
	HookEvent("server_removeban", Event_server_removeban, EventHookMode_Post);
	AddCommandListener(removeid, "removeid");

	// Create sqlite db
	decl String:error[255];
	new Handle:db = INVALID_HANDLE;
	db = SQLite_UseDatabase("stb-sqlite", error, sizeof(error));

	if (db == INVALID_HANDLE)
	{
		CloseHandle(db);
		SetFailState("error create database: %s", error);
	}

	SQL_LockDatabase(db);
	SQL_FastQuery(db, "CREATE TABLE IF NOT EXISTS stb (steamid PRIMARY KEY, duration INT, timestamp INT, name, admin, reason, date);");
	SQL_UnlockDatabase(db);
	CloseHandle(db);

	// Clear old expired bans from db
	CreateTimer(5.0, ExecuteBans)

	// Create plugin configuration file in ...cfg/sourcemod/
	AutoExecConfig(true, "stb");
}


public OnClientPostAdminCheck(client)
{
	// Skip bots and admins
	if(IsFakeClient(client) || CheckCommandAccess(client, "stb_immunity", ADMFLAG_UNBAN))
	{
		return;
	}

	// Get client steamid
	decl String:networkid[32];
	GetClientAuthString(client, networkid, sizeof(networkid));

	// steamid sucks
	if(StrEqual(networkid, "", false) || StrEqual(networkid, "STEAM_ID_PENDING", false) || StrEqual(networkid, "STEAM_ID_LAN", false) || strcmp(networkid, "STEAM_", true) == -1 || strlen(networkid) < 11 )
	{
		return;
	}


	if(sql_checkid(networkid, 0))	// Is steamid already in db
	{
		if(!sql_checkid(networkid, 2))	// Is there player name in db
		{
			decl String:name[MAX_NAME_LENGTH];
			GetClientName(client, name, sizeof(name));	// Get that player name

			sql_save(networkid, 0, name, "", "", 5);	// Update that name in db
		}

		sql_checkban(client);	// Check player ban and do rest
	}
}