new floodcounter[MAXPLAYERS] = 0;

public Action:PrintList(client, args)
{
	if(floodcounter[client] >= 1)
	{
		PrintToConsole(client, "[STB] Flooding protection, please try again after few seconds.");
		return Plugin_Handled;
	}
	else if(floodcounter[client] <= 1)
	{
		floodcounter[client]++;
		CreateTimer(2.0, wait, client);
	}

	decl String:Arguments[10];
	GetCmdArgString(Arguments, sizeof(Arguments));

	decl String:arg[65];
	BreakString(Arguments, arg, sizeof(arg));

	new skip = StringToInt(arg);

	if(skip < 0)
	{
		PrintToConsole(client, "[STB] sm_stb_list\nList next 5 bans");
		return Plugin_Handled;
	}

	decl String:error[255];
	new Handle:db = INVALID_HANDLE;
	db = SQLite_UseDatabase("stb-sqlite", error, sizeof(error));

	if (db == INVALID_HANDLE)
	{
		CloseHandle(db);
		SetFailState("SQL error: %s", error);
	}

	decl String:s_query[255];
	Format(s_query, sizeof(s_query), "SELECT * FROM stb");
	new Handle:query = SQL_Query(db, s_query);

	SQL_LockDatabase(db);

	if(query == INVALID_HANDLE)
	{
		LogError("PrintList = Query Handle %x has no results", query);
		SQL_UnlockDatabase(db);
		CloseHandle(db);
		//CloseHandle(query);
		return Plugin_Handled;
	}

	decl String:steamid[30], duration, timestamp, String:name[MAX_NAME_LENGTH], String:admin[MAX_NAME_LENGTH], String:reason[30], String:date[30];

	new rows = SQL_GetRowCount(query);	// Get number of rows

	for (new i = 0; i < rows; i++)	// Make loop by rows count
	{
		SQL_FetchRow(query)	// Go every row

		if(i >= skip && i <= (skip + 4))	// List only 5 bans, and skip first bans by 'skip' value
		{

			SQL_FetchString(query, 0, steamid, sizeof(steamid));
			duration = SQL_FetchInt(query, 1);
			timestamp = SQL_FetchInt(query, 2);
			SQL_FetchString(query, 3, name, sizeof(name));
			SQL_FetchString(query, 4, admin, sizeof(admin));
			SQL_FetchString(query, 5, reason, sizeof(reason));
			SQL_FetchString(query, 6, date, sizeof(date));

			new a = GetTime() - timestamp;
			new b = (duration*60) - a;

			new days = b/86400;
			new hrs = (b/3600)%24;
			new mins = (b/60)%60;
			new sec = b%60;

			if(b >= 1)	// Ban left
			{
				PrintToConsole(client, "  %s   name: %s\n  Banned %id %ih %im %is left\n  %s   reason: %s\n  Date: %s\n", steamid, name, days, hrs, mins, sec, admin, reason, date);
			}
			else	// Ban expired
			{
				PrintToConsole(client, "x %s   name: %s\n  Ban expire or unbanned %id %ih %im %is ago\n  %s   reason: %s\n  Date: %s\n", steamid, name, days, hrs, mins, sec, admin, reason, date);
			}
		}
	}

	SQL_UnlockDatabase(db);
	CloseHandle(db);
	CloseHandle(query);

	if(skip >= (rows - 5))	// Print this msg if there is no more bans
	{
		PrintToConsole(client, "[STB] End of ban list");
	}
	else	// Print this message if there more bans
	{
		PrintToConsole(client, "[STB] sm_stb_list %i\nList next 5 bans", skip+5);
	}

	return Plugin_Handled;
}


public Action:wait(Handle:timer, any:client)
{
	floodcounter[client] = 0;
}