﻿#!/usr/bin/env python

import es
import playerlib
import cmdlib
import popuplib
import gamethread
import cfglib

# === DO NOT EDIT THIS FILE !!! ===
# === EDIT THE CONFIG.CFG !!! ===

info = es.AddonInfo()
info.name = 'Trikz'
info.version = '1.0'
info.basename = 'crazytrikz'
info.author = 'Craziest'
info.description = 'A plugin to handle trikz_ maps'

es.ServerVar('trikz_version', info.version).makepublic()

cfg = cfglib.AddonCFG(es.getAddonPath("crazytrikz") + "/config/config.cfg")

cfg.text('************************')
cfg.text('*** TRIKZ MAP PLUGIN ***')
cfg.text('************************')
cfg.text('')
cfg.text('You can load this file with:')
cfg.text('- es_load crazytrikz')
cfg.text('')
cfg.text('Avaliable client commands:')
cfg.text('!switch -  To switch between blocking and unblocking mod')
cfg.text('!trikz - To open the scripts main menu (configurable below)')
cfg.text('')
cfg.text('************************')
cfg.text('***** CONFIGURATION ****')
cfg.text('************************')
cfg.text('')
cfg.text('Edit the following settings to your needs')
cfg.text('')
menuCommand = cfg.cvar('trikz_menu_command', "!trikz", 'The command to open the main menu')
switchCommand = cfg.cvar('trikt_switch_command', "!switch", "The command to switch between block and noblock")
enableGhost = cfg.cvar('trikz_enable_ghost', 1, 'Enable ghosting/noghosting option to players')
enableUnliHealth = cfg.cvar('trikz_unlimited_health', 1, 'Enable unlimited health (so players can die from damage)')
enableUnliFlash = cfg.cvar('trikz_unlimited_flash', 1, 'Enable the unlimited flash option')
autoRespawn = cfg.cvar('trikz_auto_respawn', 0, 'Enable auto-respawning in the case the player dies')
serverConfig = cfg.cvar('trikz_server_config', 1, 'Set the server variables needed to play trikz_ on map start')
cfg.text('')
cfg.text('If you have any suggetions/problems please post on the forums')
cfg.text('')
cfg.text('Other option of contact: craziest994 - Steam Name')
cfg.text('')
cfg.text('Coded by .craziesT')

cfg.write()

# === Load / Unload ===

def load():
    global userDict
    userDict = {}
    cmdlib.registerSayCommand(menuCommand, trikzCmd, "Trikz Menu Command")
    cmdlib.registerSayCommand(switchCommand, switchCmd, "Trikz Switch Command")
    es.set('eventscripts_noisy', 1)
    for x in es.getUseridList():
        uid = es.getplayersteamid(x)
        if uid not in userDict:
            userDict[uid] = {}
            userDict[uid]['flash'] = 0
            if enableGhost:
                userDict[uid]['ghost'] = 1
            else:
                userDict[uid]['ghost'] = 0
            userDict[uid]['checkpoints'] = {}
            userDict[uid]['чекпоинт']['1st'] = 0, 0, 0
            userDict[uid]['checkpoints']['2nd'] = 0, 0, 0
    if str(es.ServerVar('eventscripts_currentmap')).startswith('trikz_'):
        ff = es.ServerVar('mp_friendlyfire')
        lim = es.ServerVar('mp_limitteams')
        grav = es.ServerVar('sv_gravity')
        acc = es.ServerVar('sv_airaccelerate')
        if serverConfig:
            ff.set(0)
            grav.set(800)
            acc.set(250)
            lim.set(0)
    cfg.execute()
    
def unload():
    global userDict
    cmdlib.unregisterSayCommand(menuCommand)
    cmdlib.unregisterSayCommand(switchCommand)
    es.set('eventscripts_noisy', 0)
        
# === Wrappers ===

def tell(userid, text):
    es.tell(userid, '#multi', '#lightgreenСерверное меню #default:#green ' + text)

# === Events ===

def es_map_start(ev):
    ff = es.ServerVar('mp_friendlyfire')
    lim = es.ServerVar('mp_limitteams')
    grav = es.ServerVar('sv_gravity')
    acc = es.ServerVar('sv_airaccelerate')
    if serverConfig:
        ff.set(0)
        grav.set(800)
        acc.set(250)
        lim.set(0)
    for x in userDict:
        userDict[x]['checkpoints']['1st'] = 0, 0, 0
        userDict[x]['checkpoints']['2nd'] = 0, 0, 0

def player_activate(ev):
    global userDict
    userid = int(ev['userid'])
    uid = es.getplayersteamid(userid)
    if uid not in userDict:
        userDict[uid] = {}
        userDict[uid]['flash'] = 0
        if enableGhost:
            userDict[uid]['ghost'] = 1
        else:
            userDict[uid]['ghost'] = 0
        userDict[uid]['checkpoints'] = {}
        userDict[uid]['checkpoints']['1st'] = 0, 0, 0
        userDict[uid]['checkpoints']['2nd'] = 0, 0, 0
    tell(userid, 'Введите в чат #lightgreen%s#green чтобы открыть меню.' % menuCommand)

def player_spawn(ev):
    userid = int(ev['userid'])
    uid = es.getplayersteamid(userid)
    player = playerlib.getPlayer(userid)
    
    if enableGhost:
        if userDict[uid]['ghost'] == 1:
            player.setColor(255, 255, 255, 100)
            es.setplayerprop(userid, "CCSPlayer.baseclass.baseclass.baseclass.baseclass.baseclass.baseclass.m_CollisionGroup", 2)
    if enableUnliHealth:
        es.setplayerprop(userid, "CBasePlayer.m_iHealth", 1000)
    
def player_hurt(ev):
    if enableUnliHealth:
        es.setplayerprop(ev['userid'], "CBasePlayer.m_iHealth", 1000)
        
def player_death(ev):
    if autoRespawn:
        es.server.queuecmd('est_Spawn %s 1' % ev['userid'])
        tell(ev['userid'], 'Вы возродились.')
    
def weapon_fire(ev):
    uid = es.getplayersteamid(ev['userid'])
    
    if ev['weapon'] == 'flashbang':
        if enableUnliFlash:
            if userDict[uid]['flash'] == 1:
                es.server.queuecmd('es_xgive %s weapon_flashbang' % ev['userid'])
        es.delayed(1.45, 'es_xremove flashbang_projectile')
        
def flashbang_detonate(ev):
    for x in es.getUseridList():
        es.setplayerprop(x, "CCSPlayer.m_flFlashDuration", (0, 8))
        
# === Commands ===
        
def trikzCmd(userid, args):
    uid = es.getplayersteamid(userid)
    
    menu = popuplib.create('user_menu')
    menu.addline('Серверное меню')
    menu.addline('-----------------------')
    menu.addline('->1. Взять 1 Слеповую гранату')
    menu.addline('->2. Включить бесконечные слеповые гранаты')
    menu.addline('->3. Спец. способности')
    menu.addline('->4. Меню телепорта')
    menu.addline('->5. Возрождение')
    menu.addline('-----------------------')
    menu.addline('0. Закрыть меню')
    
    menu.send(userid)
    
    menu.menuselect = mainSelect
    
def mainSelect(userid, choice, popupid):
    global userDict
    player = playerlib.getPlayer(userid)
    uid = es.getplayersteamid(userid)
    if choice == 1:
        if player.getFB() in (0, 1):
            es.server.queuecmd('es_xgive %s weapon_flashbang' % userid)
            tell(userid, 'Вы получили одну слеповую гранату.')
        else:
            tell(userid, 'У вас максимум слеповых гранат.')
        popuplib.send('user_menu', userid)
    elif choice == 2:
        if enableUnliFlash:
            if userDict[uid]['flash'] == 0:
                userDict[uid]['flash'] = 1
                tell(userid, 'Вы #lightgreenвключили#green неограниченное кол-во слеповых гранат.')
            else:
                userDict[uid]['flash'] = 0
                tell(userid, 'Вы #lightgreenотключили#green неограниченное кол-во слеповых гранат.')
        else:
            tell(userid, 'Сервер отключил эту способность.')
        popuplib.send('user_menu', userid)
    elif choice == 3:
        if userDict[uid]['ghost'] == 1:
            userDict[uid]['ghost'] = 0
            es.setplayerprop(userid, "CCSPlayer.baseclass.baseclass.baseclass.baseclass.baseclass.baseclass.m_CollisionGroup", 0)
            player.setColor(255, 255, 255, 255)
            tell(userid, 'Вы #lightgreenснова#green стали смертным.')
        else:
            if enableGhost:
                userDict[uid]['ghost'] = 1
                es.setplayerprop(userid, "CCSPlayer.baseclass.baseclass.baseclass.baseclass.baseclass.baseclass.m_CollisionGroup", 2)
                player.setColor(255, 255, 255, 100)
                tell(userid, 'Вы стали #lightgreenпризраком#green.')
            else:
                tell(userid, 'Сервер отключил призрачность.')
        popuplib.send('user_menu', userid)
    elif choice == 4:
        cp = popuplib.create('checkpoints')
        cp.addline('Меню Телепорта')
        cp.addline('-----------------------')
        cp.addline('->1. Сохранить место для 1-ого телепорта')
        cp.addline('->2. Телепортироватся на 1-ое место телепорта')
        cp.addline(' ')
        cp.addline('->3. Сохранить место для 2-ого телепорта')
        cp.addline('->4. Телепортироватся на 2-ое место телепорта')
        cp.addline('-----------------------')
        cp.addline('->9. В главное меню')
        cp.addline('0. Выход')
        
        cp.menuselect = cpSelect
        cp.send(userid)
    elif choice == 5:
        if player.isdead:
            es.server.queuecmd('est_Spawn %s 1' % userid)
            tell(userid, 'Вы возродились.')
        else:
            tell(userid, 'Возродится можно только после смерти.')
        popuplib.send('user_menu', userid)
        
    elif choice == 6:
        tell(userid, 'Created by #lightgreen.craziesT#green - Steam Name: #lightgreencraziest994')
        popuplib.send('user_menu', userid)
            
def cpSelect(userid, choice, popupid):
    global userDict
    uid = es.getplayersteamid(userid)
    
    if choice == 1:
        if es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_hGroundEntity") != -1:
            userDict[uid]['checkpoints']['1st'] = es.getplayerlocation(userid)
            tell(userid, 'Вы сохранили место для #lightgreen1-ого#green телепорта.')
        else:
            tell(userid, 'Вы должны стоять на земле.')
        popuplib.send('checkpoints', userid)
    elif choice == 2:
        if userDict[uid]['checkpoints']['1st'] != (0, 0, 0):
            location = userDict[uid]['checkpoints']['1st']
            es.server.queuecmd('es_setpos %s %s %s %s' % (userid, location[0], location[1], location[2]))
        else:
            tell(userid, 'Вы еще не сохранили место 1-ого телепорта.')
        popuplib.send('checkpoints', userid)
    elif choice == 3:
        if es.getplayerprop(userid, "CCSPlayer.baseclass.localdata.m_hGroundEntity") != -1:
            userDict[uid]['checkpoints']['2nd'] = es.getplayerlocation(userid)
            tell(userid, 'Вы сохранили место для #lightgreen2-ого#green телепорта.')
        else:
            tell(userid, 'Вы должны стоять на земле.')
        popuplib.send('checkpoints', userid)
    elif choice == 4:
        if userDict[uid]['checkpoints']['2nd'] != (0, 0, 0):
            location = userDict[uid]['checkpoints']['2nd']
            es.server.queuecmd('es_setpos %s %s %s %s' % (userid, location[0], location[1], location[2]))
        else:
            tell(userid, 'Вы еще не сохранили место 1-ого телепорта.')
        popuplib.send('checkpoints', userid)
    elif choice in (5, 6, 7, 8):
        popuplib.send('checkpoints', userid)
    elif choice == 9:
        popuplib.send('user_menu', userid)
            
def switchCmd(userid, args):
    uid = es.getplayersteamid(userid)
    player = playerlib.getPlayer(userid)
    
    if userDict[uid]['ghost'] == 1:
        userDict[uid]['ghost'] = 0
        es.setplayerprop(userid, "CCSPlayer.baseclass.baseclass.baseclass.baseclass.baseclass.baseclass.m_CollisionGroup", 0)
        player.setColor(255, 255, 255, 255)
        tell(userid, 'Вы снова #lightgreenстали#green смертным.')
    else:
        if enableGhost:
            userDict[uid]['ghost'] = 1
            es.setplayerprop(userid, "CCSPlayer.baseclass.baseclass.baseclass.baseclass.baseclass.baseclass.m_CollisionGroup", 2)
            player.setColor(255, 255, 255, 100)
            tell(userid, 'Вы снова #lightgreenстали#green призраком.')
        else:
            tell(userid, 'Сервер отключил призрачность.')
            
# === CODED BY CRAZIEST - DO NOT EDIT WITHOUT ASKING FIRST ===