#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement for CS:S by fratacos
# Version 0.71

import es
import est
import gamethread
import os.path
import cmdlib

es.ServerVar("est_dead_chat", 0, "enable/disable dead chat")
es.ServerVar("est_allowadvanceddrop", 0, "allow/disallow to drop unusual items")
es.ServerVar("est_enable_weapon_restrictions", 0, "enable/disable restrict weapon functions")
es.ServerVar("est_enable_weapon_mods", 0, "enable/disable modding weapon functions")
es.ServerVar("est_enable_PerUserKeyEvents", 0, "enable/disable est_client_keypress event")
es.ServerVar("est_enable_PerUserKeyHook", 0, "do not affect in est4css")

es.ServerVar("est_Hook_Cheatish", 0, "enable/disable hooking server-side cheat commands [es_tooks.cfg only]")
es.ServerVar("est_Hook_Kill", 0, "enable/disable hooking user 'kill' command [es_tooks.cfg only]")

es.ServerVar("est_debug", 0)
es.ServerVar("est_conprint", 0)
es.ServerVar("est_Message_Mode", 0)
es.ServerVar("est_Max_Read_Line", 0)
es.ServerVar("est_Hook_Menu", 0)
es.ServerVar("est_Banned_Entities", 0)
es.ServerVar("est_enable_autorebuy_hook", 0)
es.ServerVar("est_enable_weapon_speed_mods", 0)
es.ServerVar("est_enable_gravity_reseting", 0)
es.ServerVar("est_blackhole_size", 0)
es.ServerVar("est_blackhole_gravity", 0)
es.ServerVar("est_blackhole_pulse", 0)
es.ServerVar("est_blackhole_eats", 0)
es.ServerVar("est_Hook_Fire", 0)
es.ServerVar("est_Hook_Events_Matching", 0)
es.ServerVar("est_enable_est_bullet_impact", 0)
es.ServerVar("est_enable_est_player_shoot", 0)
es.ServerVar("est_enable_est_weapon_reload", 0)
es.ServerVar("est_enable_est_player_weapon_switch", 0)
es.ServerVar("est_enable_Anti_Crash", 0)
es.ServerVar("est_MakeAdmin", 0)
resourcepath = "addons/est/es_tools.res"

def est_help(command = ""):
	global reg_list
	if command == "":
		for key in reg_list:
			es.printmsg("%s - %s\n" % (key, reg_list[key][5]))
			es.printmsg("%s %s\n" % (key, reg_list[key][4]))
	elif command in reg_list:
		es.printmsg("%s - %s\n" % (command, reg_list[command][5]))
		es.printmsg("%s %s\n" % (command, reg_list[command][4]))

def est_credits():
	es.printmsg("***\n\nest4css - yet another ES_Tools replacement for Counter-Strike:Source\nby fratacos\n\n*** PLUGINS/ADDONS ***\n\nEventScripts - Mattie\nES_Tools - Awuh0\nSource Python Extensions - your-name-here\nNativeTools - Chrisber\n\nEST Commands - freddukes\nFake Es_tools - bonbon\n\n*** THANKS TO ***\nmicomico\nL'In20Cible\nblodia\n\n*** DEBUG/TEST USERS ***\nM41*, TOFU, 753, ABC, Lak, and kanachan.\n\n***\n")

reg_list = {
"est_adddownload":[est.adddownload, 1, 1, 0, "<path>", ""],
"est_armor":[est.armor, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_armoradd":[est.armoradd, 2, 2, 0, "<users> <value>", ""],
"est_ban":[est.ban, 2, 3, 0, "<users> <time> [reason]", ""],
"est_burn":[est.burn, 1, 2, 0, "<users> [time]", ""],
"est_cash":[est.cash, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_cashadd":[est.cashadd, 2, 2, 0, "<users> <value>", ""],
"est_cexec":[est.cexec, 2, 2, 0, "<users> <command>", ""],
"est_closefile":[est.closefile, 1, 1, 0, "<fileid>", ""],
"est_countents":[est.countents, 2, 2, 1, "<variable> <entity name>", ""],
"est_countlines":[est.countlines, 2, 2, 1, "<variable> <fileid>", ""],
"est_credits":[est_credits, 0, 0, 0, "", ""],
"est_csay":[est.csay, 2, 2, 0, "<users> <text>", ""],
"est_curtime":[est.curtime, 1, 1, 1, "<variable>", "return the internal global time"],
"est_cvaraddflag":[est.cvaraddflag, 9, 9, 0, "<cvar> <gamedll> <protected> <sponly> <notify> <cheat> <userinfo> <unlogged> <replicated>", ""],
"est_cvardelflag":[est.cvardelflag, 9, 9, 0, "<cvar> <gamedll> <protected> <sponly> <notify> <cheat> <userinfo> <unlogged> <replicated>", ""],
"est_damage":[est.damage, 3, 3, 0, "<source user> <target users> <value>", ""],
"est_deafen":[est.deafen, 5, 5, 0, "<users> <total time> <percent> <fadeout time> <fadeback time>", ""],
"est_deathadd":[est.deathadd, 2, 2, 0, "<users> <value>", ""],
"est_deaths":[est.deaths, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_deathset":[est.deathset, 2, 2, 0, "<users> <value>", ""],
"est_deleteragdolls":[est.deleteragdolls, 0, 1, 0, "[users]", ""],
"est_dissolve":[est.dissolve, 1, 5, 0, "<class name> [type] [time] [origin] [magnitude]", ""],
"est_dropweapon":[est.dropweapon, 2, 2, 0, "<users> <weapon name/slot>", ""],
"est_drug":[est.drug, 1, 2, 0, "<users> [time]", ""],
"est_drunk":[est.drunk, 1, 2, 0, "<users> [time]", ""],
"est_endround":[est.endround, 2, 2, 0, "<time> <reason>", ""],
"est_entphyspush":[est.entphyspush, 4, 4, 0, "<index> <x> <y> <z>", ""],
"est_entpushto":[est.entpushto, 5, 5, 0, "<index> <x> <y> <z> <force>", ""],
"est_entteleport":[est.entteleport, 4, 4, 0, "<index> <x> <y> <z>", ""],
"est_extinguish":[est.extinguish, 1, 1, 0, "<users>", ""],
"est_fade":[est.fade, 8, 8, 0, "<users> <type> <fadetime> <totaltime> <r> <g> <b> <a>", ""],
"est_fileexists":[est.fileexists, 2, 2, 1, "<variable> <path>", ""],
"est_freeze":[est.freeze, 2, 2, 0, "<users> <1,0>", ""],
"est_getammo":[est.getammo, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getarmor":[est.getarmor, 2, 2, 1, "<variable> <users>", ""],
"est_getchat":[est.getchat, 2, 2, 1, "<variable> <users>", ""],
"est_getclipammo":[est.getclipammo, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getdeaths":[est.getdeaths, 2, 2, 1, "<variable> <users>", ""],
"est_getentclassname":[est.getentclassname, 2, 2, 1, "<variable> <index>", ""],
"est_getentityindex":[est.getentityindex, 3, 3, 1, "<variable> <users> <classname>", ""],
"est_getentname":[est.getentname, 2, 2, 1, "<variable> <index>", ""],
"est_getescort":[est.getescort, 2, 2, 1, "<variable> <users>", ""],
"est_geteventinfo":[est.geteventinfo, 2, 2, 1, "<variable> <key name>", ""],
"est_geteyecoord":[est.geteyecoord, 4, 4, 0, "<users> <variable x> <variable y> <variable z>", ""],
"est_getfb":[est.getfb, 2, 2, 1, "<variable> <users>", ""],
"est_getgravity":[est.getgravity, 2, 2, 1, "<variable> <users>", ""],
"est_getgun":[est.getgun, 2, 2, 1, "<variable> <users>", "return an user's active weapon name"],
"est_getguncoord":[est.getguncoord, 4, 4, 0, "<users> <variable x> <variable y> <variable z>", ""],
"est_getkills":[est.getkills, 2, 2, 1, "<variable> <users>", ""],
"est_gethe":[est.gethe, 2, 2, 1, "<variable> <users>", ""],
"est_gethealth":[est.gethealth, 2, 2, 1, "<variable> <users>", ""],
"est_getindex":[est.getindex, 2, 2, 1, "<variable> <users>", ""],
"est_getip":[est.getip, 2, 2, 1, "<variable> <users>", ""],
"est_getline":[est.getline, 3, 3, 1, "<variable> <fileid> <line no>", ""],
"est_getname":[est.getname, 2, 2, 1, "<variable> <users>", ""],
"est_getnamedoffset":[est.getnamedoffset, 3, 3, 1, "<variable> <index> <property>", ""],
"est_getoffset":[est.getoffset, 3, 3, 1, "<variable> <index> <property>", ""],
"est_getplayerdistance":[est.getplayerdistance, 5, 5, 0, "<variable distance> <variable azimuth> <variable elevation> <users1> <users2>", ""],
"est_getplayerlocation":[est.getplayerlocation, 2, 2, 1, "<variable> <users>", ""],
"est_getprimary":[est.getprimary, 2, 2, 1, "<variable> <users>", ""],
"est_getsecondary":[est.getsecondary, 2, 2, 1, "<variable> <users>", ""],
"est_getsg":[est.getsg, 2, 2, 1, "<variable> <users>", ""],
"est_getslot":[est.getslot, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_getsteam":[est.getsteam, 2, 2, 1, "<variable> <users>", ""],
"est_getteam":[est.getteam, 2, 2, 1, "<variable> <users>", ""],
"est_getuserid":[est.getuserid, 2, 2, 1, "<variable> <users>", ""],
"est_getviewangle":[est.getviewangle, 4, 4, 0, "<users> <variable pitch> <variable yaw> <variable roll>", ""],
"est_getviewcoord":[est.getviewcoord, 4, 4, 0, "<users> <variable x > <variable y> <variable z>", ""],
"est_getviewprop":[est.getviewprop, 2, 2, 2, "<users> <variable>", ""],
"est_getviewplayer":[est.getviewplayer, 2, 2, 2, "<users> <variable>", ""],
"est_getweaponindex":[est.getweaponindex, 3, 3, 1, "<variable> <users> <weapon name/slot>", ""],
"est_give":[est.give, 2, 2, 0, "<users> <string>", "give an item for users"],
"est_god":[est.god, 1, 2, 0, "<users> [1,0]", "make users no hurt and no death status"],
"est_hasdefuser":[est.hasdefuser, 2, 2, 1, "<variable> <users>", ""],
"est_hashelmet":[est.hashelmet, 2, 2, 1, "<variable> <users>", ""],
"est_haskevlar":[est.haskevlar, 2, 2, 1, "<variable> <users>", ""],
"est_health":[est.health, 2, 3, 0, "<users> <+,-,=,value> [value]", ""],
"est_healthadd":[est.healthadd, 2, 2, 0, "<users> <value>", ""],
"est_help":[est_help, 0, 1, 0, "[command name]", ""],
"est_hookkey":[est.hookkey, 2, 2, 0, "<users> <key name>", ""],
"est_hsay":[est.hsay, 2, 2, 0, "<users> <text>", ""],
"est_isalive":[est.isalive, 2, 2, 1, "<variable> <users>", ""],
"est_isalpha":[est.isalpha, 2, 2, 1, "<variable> <string>", ""],
"est_isbomber":[est.isbomber, 2, 2, 1, "<variable> <users>", ""],
"est_isnumeric":[est.isnumeric, 2, 2, 1, "<variable> <string>", ""],
"est_isonly":[est.isonly, 3, 3, 1, "<variable> <string> <check letters>", ""],
"est_jetpack":[est.jetpack, 2, 2, 0, "<users> <1,0>", ""],
"est_kick":[est.kick, 1, 2, 0, "<users> [reason]", ""],
"est_killadd":[est.killadd, 2, 2, 0, "<users> <value>", ""],
"est_kills":[est.kills, 3, 3, 0, "<users> <+,-,=> <value>", ""],
"est_killset":[est.killset, 2, 2, 0, "<users> <value>", ""],
"est_knifeonly":[est.knifeonly, 2, 2, 1, "<variable> <users>", ""],
"est_lightstyle":[est.lightstyle, 2, 2, 0, "<render style> <a-z>", ""],
"est_loadweaponmod":[est.loadweaponmod, 1, 1, 0, "<file name>", ""],
"est_loop":[est.loop, 3, 3, 0, "<variable> <users> <command>", ""],
"est_modplayerweapon":[est.modplayerweapon, 3, 3, 0, "<users> <weapon> <value>", ""],
"est_modweapon":[est.modweapon, 2, 2, 0, "<weapon> <value>", ""],
"est_motd_f":[est.motd_f, 4, 4, 0, "<users> <title> <command> <path>", "show motd of uses' file"],
"est_motd_t":[est.motd_t, 4, 4, 0, "<users> <title> <command> <text>", "show motd of text"],
"est_motd_w":[est.motd_w, 4, 4, 0, "<users> <title> <command> <url>", "show motd of URL"],
"est_msg":[est.msg, 2, 2, 0, "<users> <string>", "print message to specific users"],
"est_name":[est.name, 2, 2, 0, "<users> <string>", "return an user's name"],
"est_near":[est.near, 5, 5, 0, "<variable> <users> <distance> <base user> <command>", ""],
"est_nearcoord":[est.nearcoord, 7, 7, 0, "<variable> <users> <distance> <x> <y> <z> <command>", ""],
"est_noclip":[est.noclip, 2, 2, 0, "<users> <1,0>", ""],
"est_openfile":[est.openfile, 3, 3, 1, "<variable> <flag(r/w)> <path>", ""],
"est_physpush":[est.physpush, 4, 4, 0, "<users> <x> <y> <z>", ""],
"est_play":[est.play, 2, 4, 0, "<users> <path> [duration] [volume]", ""],
"est_playedict":[est.playedict, 2, 4, 0, "<index> <path> [volume] [attenuation]", ""],
"est_playercount":[est.playercount, 2, 2, 1, "<variable> <users>", ""],
"est_playplayer":[est.playplayer, 2, 4, 0, "<users> <path> [volume] [attenuation]", ""],
"est_pushto":[est.pushto, 5, 5, 0, "<users> <x> <y> <z> <force>", ""],
"est_randplayer":[est.randplayer, 2, 2, 1, "<variable> <users>", ""],
"est_regclientcmd":[est.regclientcmd, 2, 2, 0, "<command> <1,0>", ""],
"est_regeventblock":[est.regeventblock, 2, 2, 0, "<event name> <command>", ""],
"est_regsayhook":[est.regsayhook, 2, 2, 0, "<text> <0=identical,1=partial>", ""],
"est_remove":[est.remove, 1, 1, 0, "<entity>", ""],
"est_removeidle":[est.removeidle, 1, 1, 0, "<weapon / weapon_...>", ""],
"est_removeweapon":[est.removeweapon, 2, 2, 0, "<users> <weapon name/slot>", ""],
"est_rescued":[est.rescued, 1, 1, 1, "<variable>", ""],
"est_restrict":[est.restrict, 2, 2, 0, "<users> <weapon>", "limit specific weapon for users"],
"est_restrictall":[est.restrictall, 1, 1, 0, "<users>", "limit all weapons, include knife,  for users"],
"est_rocket":[est.rocket, 1, 1, 0, "<users>", "jump, smoke, and explosion effects for users"],
"est_rounddecimal":[est.rounddecimal, 3, 3, 1, "<variable> <value> <places>", ""],
"est_setaim":[est.setaim, 3, 3, 0, "<source user> <target users> <z diff>", ""],
"est_setammo":[est.setammo, 3, 3, 0, "<users> <weapon name/slot> <value>", ""],
"est_setarmor":[est.setarmor, 2, 2, 0, "<users> <value>", ""],
"est_setcash":[est.setcash, 2, 2, 0, "<users> <value>", ""],
"est_setclipammo":[est.setclipammo, 3, 3, 0, "<users> <weapon name/slot> <value>", ""],
"est_setentitycolor":[est.setentitycolor, 5, 5, 0, "<index> <r> <g> <b> <a>", ""],
"est_setentmodel":[est.setentmodel, 2, 2, 0, "<indel> <model path>", ""],
"est_setentname":[est.setentname, 2, 2, 0, "<index> <name>", ""],
"est_seteventinfo":[est.seteventinfo, 2, 2, 0, "<key name> <value>", ""],
"est_setgravity":[est.setgravity, 2, 2, 0, "<users> <ratio>", ""],
"est_sethealth":[est.sethealth, 2, 2, 0, "<users> <value>", ""],
"est_setmodel":[est.setmodel, 2, 2, 0, "<users> <model path>", ""],
"est_setoffset":[est.setoffset, 2, 2, 0, "<index> <property> <value>", ""],
"est_setplayercolor":[est.setplayercolor, 5, 6, 0, "<users> <r> <g> <b> <a> [1:include weapon/0:player only]", ""],
"est_setviewangle":[est.setviewangle, 4, 4, 0, "<users> <pitch> <yaw> <roll>", ""],
"est_setviewcoord":[est.setviewcoord, 4, 4, 0, "<users> <x> <y> <y>", ""],
"est_shake":[est.shake, 4, 4, 0, "<users> <time> <distance> <value>", ""],
"est_showmenu":[est.showmenu, 3, 3, 0, "<time> <users> <text>", ""],
"est_slay":[est.slay, 1, 1, 0, "<users>", "commit users to suicide"],
"est_spawn":[est.spawn, 1, 2, 0, "<users> [1,0]", "(force) respawn users"],
"est_speed":[est.speed, 2, 2, 0, "<users> <speed>", "change users' speed (default=1)"],
"est_stopsound":[est.stopsound, 2, 2, 0, "<users> <path>", ""],
"est_stripplayer":[est.stripplayer, 2, 2, 0, "<users> <1,0>", ""],
"est_strlen":[est.strlen, 2, 2, 1, "<variable> <string>", ""],
"est_strtolower":[est.strtolower, 2, 2, 1, "<variable> <string>", ""],
"est_strtoupper":[est.strtoupper, 2, 2, 1, "<variable> <string>", ""],
"est_team":[est.team, 2, 2, 0, "<users> <team>", "change users' team number"],
"est_teleport":[est.teleport, 4, 4, 0, "<users> <x> <y> <z>", ""],
"est_trimdecimal":[est.trimdecimal, 3, 3, 1, "<variable> <value> <places>", ""],
"est_unhookkey":[est.unhookkey, 2, 2, 0, "<users> <key name>", ""],
"est_unregclientcmd":[est.unregclientcmd, 1, 1, 0, "<command>", ""],
"est_unregeventblock":[est.unregeventblock, 1, 2, 0, "<event name> [command]", ""],
"est_unregsayhook":[est.unregsayhook, 1, 1, 0, "<text>", ""],
"est_unrestrict":[est.unrestrict, 2, 2, 0, "<users> <weapon>", ""],
"est_unrestrictall":[est.unrestrictall, 1, 1, 0, "<users>", ""],
"est_uptime":[est.uptime, 1, 1, 1, "<variable>", "return time differences between the server's startup and present"],
}
nouser_list = ["est_getplayerdistance", "est_showmenu"]
for key in reg_list:
	if not "<users>" in reg_list[key][4]:
		nouser_list.append(key)

def load():
	for key in reg_list:
		cmdlib.registerServerCommand(key, reg_cmd, reg_list[key][5])
	if os.path.exists("cstrike/cfg/es_tools.cfg"):
		es.ServerCommand("exec es_tools.cfg")
	if os.path.exists("cstrike/%s" % resourcepath):
		es.loadevents('declare', resourcepath)
		es.loadevents(resourcepath)
	es.ServerVar("sv_hudhint_sound").set(0)
	gamethread.delayed(0.5, cvarhook)
	est.load()

def reg_cmd(args):
	global reg_list
	global nouser_list
	name = es.getargv(0)
	item = reg_list[name]
	argc = es.getargc() - 1
	if not (item[1] <= argc and argc <= item[2]):
		es.dbgmsg(0, "Syntax: " + name + " " + item[4])
		return
	func = item[0]
	arglist = [] + args
	if item[3] >= 1:
		del arglist[item[3] - 1]
	if argc != 0 and not name in nouser_list:
		arglist[0] = est.estfilter(arglist[0])
	if name in ["est_damage", "est_setaim", "est_showmenu"]:
		arglist[1] = est.estfilter(arglist[1])
	if name == "est_getplayerdistance":
		arglist[3] = est.estfilter(arglist[3])
		arglist[4] = est.estfilter(arglist[4])
		ret = func(arglist[3], arglist[4])
		if ret != None:
			es.ServerVar(arglist[0]).set(ret[0])
			es.ServerVar(arglist[1]).set(ret[1])
			es.ServerVar(arglist[2]).set(ret[2])
		return
	if name in ["est_geteyecoord", "est_getguncoord", "est_getviewangle", "est_getviewcoord"]:
		ret = func(arglist[0])
		if ret != None:
			es.ServerVar(arglist[1]).set(ret[0])
			es.ServerVar(arglist[2]).set(ret[1])
			es.ServerVar(arglist[3]).set(ret[2])
		return
	if item[3] > 0:
		ret = func(*arglist)
		if ret != None:
			es.ServerVar(es.getargv(item[3])).set(ret)
	else:
		func(*arglist)

def unload():
	est.unload()
	for key in reg_list:
		cmdlib.unregisterServerCommand(key)

def cvarhook():
	thename = "/".join(__name__.split(".")[:-1])
	if es.getInt("est_Hook_Cheatish") != 0:
		global hook_cmds
		for item in hook_cmds:
			es.regcmd(item, "%s/donothing" % thename)
	if es.getInt("est_Hook_Kill") != 0:
		es.regcmd("kill", "%s/donothing" % thename)

def donothing():
	pass

def es_map_start(event_var):
	es.loadevents(resourcepath)
	est.es_map_start(event_var)

def es_client_command(event_var):
	est.es_client_command(event_var)

def round_start(event_var):
	est.round_start(event_var)

def round_end(event_var):
	est.round_end(event_var)

def player_activate(event_var):
	est.player_activate(event_var)

def player_connect(event_var):
	est.player_connect(event_var)

def player_death(event_var):
	est.player_death(event_var)

def weapon_fire(event_var):
	est.weapon_fire(event_var)

def item_pickup(event_var):
	est.item_pickup(event_var)

def hostage_follows(event_var):
	est.hostage_follows(event_var)

def hostage_stops_following(event_var):
	est.hostage_stops_following(event_var)

def hostage_rescued(event_var):
	est.hostage_rescued(event_var)

# cheat, dump, entity, graphic, test/debug and other commands which I don't know
hook_cmds = [
"box", "buddha", "bug", "bug_swap", "camortho", "ch_createairboat", "ch_createjeep", "cl_dump_particlestats", "cl_ent_absbox", "cl_ent_bbox", "cl_ent_rbox", "cl_find_ent", "cl_find_ent_index", "cl_fullupdate", "cl_panelanimation", "cl_particles_dump_effects", "cl_precacheinfo", "cl_pred_track", "cl_removedecals", "cl_showents", "cl_soundemitter_flush", "cl_soundscape_flush", "cl_soundscape_printdebuginfo", "cl_view", "clear", "clear_debug_overlays", "cmd", "collisio_test", "commentary_cvarsnotchanging", "commentary_finishnode", "commentary_showmodelviewer", "commentary_testfirstrun", "condump", "create_flashlight", "CreateHairball", "CreatePredictionError", "creditsdone", "cs_make_vip", "dbghist_addline", "dbghist_dump", "debugsystemui", "devshots_nextmap", "devshots_screenshot", "differences", "dlight_debug", "drawcross", "drawline", "dsp_reload", "dti_flush", "dump_entity_sizes", "dump_globals", "dump_panels", "dump_particlemanifest", "dump_x360_cfg", "dump_x360_saves", "dumpentityfactories", "dumpeventqueue", "dumpgamestringtable", "dumpsavedir", "dumpstringtables", "editor_toggle", "endmovie", "ent_abbox", "ent_attachments", "ent_autoaim", "ent_bbox", "ent_cancelpendingentfires", "ent_create", "ent_dump", "ent_fire", "ent_info", "ent_keyvalue", "ent_messages", "ent_name", "ent_orient", "ent_pause", "ent_pivot", "ent_rbox", "ent_remove", "ent_remove_all", "ent_rotate", "ent_setname", "ent_step", "ent_teleport", "ent_text", "ent_viewoffset", "envmap", "explode", "explodevector", "fadein", "fadeout", "find", "find_ent", "fid_ent_index", "findflags", "firetarget", "firstperson", "flush", "flush_locked", "fogui", "force_centerview", "fov", "fs_printopenfiles", "fs_warning_level", "g15_dumpplayer", "g15_reload", "gamemenucommand", "give", "givecurrentammo", "global_set", "god", "groundlist", "hammer_update_entity", "hammer_update_safe_entities", "heartbeat", "hideradar", "hurtme", "impulse", "incrementvar", "item_show_whitelistable_definitions", "joyadvancedupdate", "kdtree_test", "key_findbinding", "key_listboundkeys", "key_updatelayout", "killserver", "light_crosshair", "lightprobe", "linefile", "listmodels", "listRecentNPCSpeech", "load", "loadcommentary", "mat_crosshair", "mat_crosshair_edit", "mat_crosshair_explorer", "mat_crosshair_printmaterial", "mat_crosshair_reloadmaterial", "mat_edit", "mat_hdr_enabled", "mat_info", "mat_reloadallmaterials", "mat_reloadmaterial", "mat_reloadtextures", "mat_reporthwmorphmemory", "mat_savechanges", "mat_setvideomode", "mat_showmaterials", "mat_showmaterialsverbose", "mat_showtextures", "mat_spewvertexandpixelshaders", "mat_texture_list_txlod", "mat_texture_list_txlod_sync", "multva", "nb_command", "nb_debug", "nb_debug_filter", "nb_delete_all", "nb_force_look_at", "nb_move_to_cursor", "nb_select", "nb_warp_selected_here", "net_channels", "net_start", "net_status", "noclip", "notarget", "overview_alpha", "overview_health", "overview_locked", "overview_mode", "overview_names", "overview_tracks", "overview_zoom", "particle_test_start", "particle_test_stop", "path", "perfui", "perfvisualbenchmark", "perfvisualbenchmark_abort", "physics_budget", "physics_constraints", "physics_debug_entity", "physics_highlight_active", "physics_report_active", "physics_select", "picker", "pixelvis_debug", "prop_crosshair", "prop_debug", "prop_dynamic_create", "prop_phsics_create", "r_3dnow", "r_cheapwaterend", "r_cheapwaterstart", "r_cleardecals", "r_flushlod", "r_printdecalinfo", "r_screenoverlay", "r_shadowangles", "r_shadowblobbycutoff", "r_shadowcolor", "r_shadowdir", "r_shadowdist", "r_sse2", "recompute_speed", "refresh_options_dialog", "report_simthinklist", "report_soundpatch", "report_touchlinks", "respawn_entities", "rr_reloadresponsesystems", "scene_flush", "setang", "setang_exact", "setmaster", "setmodel", "setpause", "setpos", "setpos_exact", "shake", "shake_stop", "showbudget_texture_global_dumptats", "showtriggers_toggle", "speak", "spike", "star_memory", "surfaceprop", "Test_CreateEntity", "test_dispatcheffect", "Test_EHandle", "test_entity_blocker", "test_freezeframe", "Test_InitRandomEntitySpawner", "Test_ProxyToggle_EnableProxy", "Test_ProxyToggle_EnsureValue", "Test_ProxyToggle_SetValue", "Test_RandomizeInPVS", "Test_RandomPlayerPosition", "Test_RemoveAllRandomEntities", "Test_SpawnRandomEntities", "testhudanim", "thirdperson", "thirdperson_mayamode", "TrackerAnim", "vehicle_flushscript", "viewanim_addkeyframe", "viewanim_create", "viewanim_load", "viewanim_reset", "viewanim_save", "viewanim_test", "voice_modenable", "voice_printtalkers", "+voicerecord", "-voicerecord", "vox_reload", "voxeltree_box", "voxeltree_playerview", "voxeltree_sphere", "voxeltree_view", "vprof", "vprof_adddebuggroup1", "vprof_cachemiss", "vprof_cachemiss_off", "vprof_cachemiss_on", "vprof_child", "vprof_collapse_all", "vprof_dump_groupnames", "vprof_expand_all", "vprof_expand_group", "vprof_generate_report", "vprof_generate_report_AI", "vprof_generate_report_AI_only", "vprof_generate_report_budget", "vprof_generate_report_hierarchy", "vprof_generate_report_map_load", "vprof_nextsibling", "vprof_off", "vprof_on", "vprof_parent", "vprof_playback_average", "vprof_playback_start", "vprof_playback_step", "vprof_playback_stepback", "vprof_playback_stop", "vprof_prevsibling", "vprof_record_start", "vprof_record_stop", "vprof_remote_start", "vprof_remote_stop", "vprof_reset", "vprof_reset_peaks", "vprof_vtune_group", "vtune", "wc_air_edit_further", "wc_air_edit_nearer", "wc_air_node_edit", "wc_create", "wc_destroy", "wc_destroy_undo", "wc_link_edit", "wipe_nav_attributes",
]