import es, nativetools as nt
from es import server_var
import playerlib, gamethread
import os, random, datetime, cPickle
from configobj import ConfigObj
# Initialize our handle list
handles = []

# all SCTF server variables are declared here for convenience 
sctf_version	  				= es.ServerVar("sctf_version",				2.0, "Current SCTF version.") 
sctf			  				= es.ServerVar("sctf",  					1, "Is SCTF enabled or disabled.") 

sctf_remove_inactive_players_after	= es.ServerVar("sctf_remove_inactive_players_after",  		35, "Remove inactive players from database after X days.") 
sctf_remove_time  				= es.ServerVar("sctf_remove_time",  		1, "Enable remove objectives and round never end.") 
sctf_remove_money  				= es.ServerVar("sctf_remove_money",  		1, "Remove any money from player.") 
sctf_clean_ground_time			= es.ServerVar("sctf_clean_ground_time",	30, "Time in seconds to clean the ground from bodys and items/weapons. Min: 1 | Max: 180") 
sctf_game_time  				= es.ServerVar("sctf_game_time",  			1, "Game time clock in Minutes. <5 = Disable.") 
sctf_score_limit				= es.ServerVar("sctf_score_limit",  		100, "When any team reach x points (Flags) game will end. 0 = Disable.") 
sctf_stats						= es.ServerVar("sctf_stats",				1, "Enable SCTF Stats.")
sctf_show_flag_status_hud		= es.ServerVar("sctf_show_flag_status_hud",	1, "Enable show a Hud with Flag information/status")
sctf_drop_flag_time				= es.ServerVar("sctf_drop_flag_time",		15, "Time to reset a droped flag. (<= 0 = Disable)")
sctf_sacrifice_for_score		= es.ServerVar("sctf_sacrifice_for_score",	0, "Player need sacrifice to score a flag")
sctf_use_classes				= es.ServerVar("sctf_use_classes",			1, "Allow player choose diferent classes with powers/weapons/items")

sctf_mapreload_settings			= es.ServerVar("sctf_mapreload_settings",	0, "Enable reload SCTF settings (sctf_server.cfg) every time map change.")
sctf_map_config					= es.ServerVar("sctf_map_config",			1, "Enable Load a diferent config for each map. See (addons/eventscripts/sctf/cfg/maps/)")

sctf_score_for_take_flag		= es.ServerVar("sctf_score_for_take_flag",	1, "Amount of Kills (+) a player will win when capture an flag.")
sctf_score_for_score_flag		= es.ServerVar("sctf_score_for_score_flag",	2, "Amount of Kills (+) a player will win when score an flag.")
sctf_score_for_return_flag		= es.ServerVar("sctf_score_for_return_flag",1, "Amount of Kills (+) a player will win when return the team flag.")
sctf_score_for_drop_flag		= es.ServerVar("sctf_score_for_drop_flag",	1, "Amount of Kills (-) a player will win when drop an flag.")

sctf_auto_spawn					= es.ServerVar("sctf_auto_spawn",			1, "Allow respawn players after dead.")
sctf_spawn_delay				= es.ServerVar("sctf_spawn_delay",			3, "Time to respawn player after dead.")
sctf_restrict_drop				= es.ServerVar("sctf_restrict_drop",		1, "Disallow players drop weapons.")

sctf_show_flags				= es.ServerVar("sctf_show_flags",		1, "Set flags ON or OFF.")

# Sounds
sctf_sound_blue_flag_taken		= es.ServerVar("sctf_sound_blue_flag_taken",  	"doors/vent_open2.wav", "Sound to listen at Blue Flag Taken (Only Team 3 [Blue] listen this sound).")  
sctf_sound_red_flag_taken		= es.ServerVar("sctf_sound_red_flag_taken",  	"doors/vent_open2.wav", "Sound to listen at Red Flag Taken (Only Team 2 [Red] listen this sound).")  

sctf_sound_blue_flag_capture	= es.ServerVar("sctf_sound_blue_flag_capture",  "items/battery_pickup.wav", "Sound to listen at Blue Flag Capture (Only Team 2 [Red] listen this sound).")  
sctf_sound_red_flag_capture		= es.ServerVar("sctf_sound_red_flag_capture",  	"items/battery_pickup.wav", "Sound to listen at Red Flag Capture (Only Team 3 [Blue] listen this sound).")  

sctf_sound_blue_flag_drop		= es.ServerVar("sctf_sound_blue_flag_drop",  	"buttons/blip1.wav", "Sound to listen at Blue Flag Drop (Only Team 3 [Blue] listen this sound).")  
sctf_sound_red_flag_drop		= es.ServerVar("sctf_sound_red_flag_drop",  	"buttons/blip1.wav", "Sound to listen at Red Flag Drop (Only Team 2 [Red] listen this sound).")  

sctf_sound_blue_flag_lost		= es.ServerVar("sctf_sound_blue_flag_lost",  	"ambient/alarms/warningbell1.wav", "Sound to listen at Blue Flag Lost (Only Team 2 [Red] listen this sound).")  
sctf_sound_red_flag_lost		= es.ServerVar("sctf_sound_red_flag_lost",  	"ambient/alarms/warningbell1.wav", "Sound to listen at Red Flag Lost (Only Team 3 [Blue] listen this sound).")  

sctf_sound_blue_flag_return		= es.ServerVar("sctf_sound_blue_flag_return",  	"ambient/explosions/explode_7.wav", "Sound to listen at Blue Flag Return (All players listen this sound).")  
sctf_sound_red_flag_return		= es.ServerVar("sctf_sound_red_flag_return",  	"ambient/explosions/explode_7.wav", "Sound to listen at Red Flag Return (All players listen this sound).")  

sctf_sound_blue_team_score		= es.ServerVar("sctf_sound_blue_team_score",  	"plats/elevbell1.wav", "Sound to listen when Blue Team Scores (All players listen this sound).")  
sctf_sound_red_team_score		= es.ServerVar("sctf_sound_red_team_score",  	"plats/elevbell1.wav", "Sound to listen when Red Team Scores (All players listen this sound).")  

sctf_sound_blue_team_wins		= es.ServerVar("sctf_sound_blue_team_wins",  	"music/HL1_song25_REMIX3.mp3", "Sound to listen when Blue Team Win the game (Only Team 3 [Blue] listen this sound).")
sctf_sound_red_team_wins		= es.ServerVar("sctf_sound_red_team_wins",  	"music/HL1_song25_REMIX3.mp3", "Sound to listen when Red Team Win the game (Only Team 2 [Red] listen this sound).")

sctf_sound_blue_team_lose		= es.ServerVar("sctf_sound_blue_team_lose",  	"music/HL1_song10.mp3", "Sound to listen when Blue Team Lost the game (Only Team 3 [Blue] listen this sound).")
sctf_sound_red_team_lose		= es.ServerVar("sctf_sound_red_team_lose",  	"music/HL1_song10.mp3", "Sound to listen when Red Team Lost the game (Only Team 2 [Red] listen this sound).")

sctf_sound_draw					= es.ServerVar("sctf_sound_draw",  				"music/HL1_song17.mp3", "Sound to listen when game end in Draw (All players listen this sound).")
# End Sounds

info = es.AddonInfo() 
info.name     	= "Capture The Flag" 
info.basename 	= "SCTF"
info.version  	= str(sctf_version)
info.url      	= "http://addons.eventscripts.com/addons/view/SCTF" 
info.description = "Capture the flag mod"
info.author   	= "sn4k3"
#info.contact  	= "Tiago_caza@hotmail.com"
#info.tags	= "sctf,flag,ctf,control point"

"""
Flag Maker:
   X   +   X1
Z1 ||||||||||
   ||      ||
   ||||||||||
   ||  -   Z2
+  ||
   ||
   ||
   ||
Z  ||
   X
   
XYZ = Original Coords
X* Y* Z* = Math for Orginal Coords

All Flags Base:
Glow (XYZ)
Beam (XYZ TO XYZ1)    
Beam (XYZ1 TO X1YZ1)  
Beam (X1YZ1 TO X1YZ2)
Beam (X1YZ2 TO XYZ2)

All Captured Flags:
Beam (XYZ2 TO X1YZ1)
Beam (XYZ1 TO X1YZ2)

Ts Not Captured Flag:
Beam (XYZ2 TO X1YZ1)

CTs Not Captured Flag:
Beam (XYZ1 TO X1YZ2)
"""



_sctf_opt = {}
_sctf_opt['dev'] = {}
_sctf_opt['dev']['db_version'] = 1.0
_sctf_opt['game_options'] = {}
_sctf_opt['game_options']['path'] = es.getAddonPath("sctf")
_sctf_opt['game_options']['game_path'] = str(es.ServerVar('eventscripts_gamedir')) 
_sctf_opt['game_options']['config_path'] = os.path.join(_sctf_opt['game_options']['path'],"cfg")
_sctf_opt['game_options']['config_short_path'] = os.path.join('addons','eventscripts','sctf','cfg')
_sctf_opt['game_options']['data_path'] = os.path.join(_sctf_opt['game_options']['path'],'data')
_sctf_opt['game_options']['game_time'] = -99
_sctf_opt['game_options']['score_limit'] = -99
_sctf_opt['game_options']['clean_idle'] = 10.0
_sctf_opt['game_options']['round_end'] = False
_sctf_opt['game_sounds'] = {
'blue_flag_taken' : str(sctf_sound_blue_flag_taken), 'red_flag_taken' : str(sctf_sound_red_flag_taken),
'blue_flag_capture' : str(sctf_sound_blue_flag_capture), 'red_flag_capture' : str(sctf_sound_red_flag_capture),
'blue_flag_drop' : str(sctf_sound_blue_flag_drop), 'red_flag_drop' : str(sctf_sound_red_flag_drop),
'blue_flag_lost' : str(sctf_sound_blue_flag_lost), 'red_flag_lost' : str(sctf_sound_red_flag_lost),
'blue_flag_return' : str(sctf_sound_blue_flag_return), 'red_flag_return' : str(sctf_sound_red_flag_return),
'blue_team_score' : str(sctf_sound_blue_team_score), 'red_team_score' : str(sctf_sound_red_team_score),
'blue_team_wins' : str(sctf_sound_blue_team_wins), 'red_team_wins' : str(sctf_sound_red_team_wins),
'blue_team_lose' : str(sctf_sound_blue_team_lose), 'red_team_lose' : str(sctf_sound_red_team_lose),
'draw' : sctf_sound_draw
}
_sctf_opt['dev_sounds'] = {
'menuselect' 	: "buttons/button14.wav", 		'menuexit' 		: "buttons/combine_button7.wav",
'menuback'		: "UI/buttonclickrelease.wav",	'menunext'		: "UI/buttonrollover.wav",
'restrict' 		: "buttons/button8.wav"
}
_sctf_opt['flag_maker'] = {}
_sctf_opt['flag_maker']['live_time'] = 1.1
_sctf_opt['flag_maker']['live'] = {
'z1' : 160, # + (z+z1)
'z2' : 40,  # -  (z1-z2)
'x1' : 65   # + (x+x1)
}
_sctf_opt['flag_maker']['drop'] = {
'z' : 63,   # - (z-z)
'z1' : 120,  # + (z+z1)
'z2' : 40,  # - (z1-z2)
'x1' : 65,  # + (x+x1)
}
# Keys: defcoord, currentcoord, color, status, team, timedrop, owner, x, y, z, dx, dy, dz
# status: 0 = UnCap | 1 = Cap | 2 = Drop
_sctf_opt['flags'] = {}

_sctf_players = {}
"""
_sctf_classes.addClass("Cowboy", "Fast but pistols only", 150, 1.7, "knife,elite:200,hegrenade,flashbang")
_sctf_classes.addClass("Scout", "Good for rush enemy flag", 50, 2.0, "knife,p228:100,mp5navy:200,hegrenade:2")
_sctf_classes.addClass("Rifleman", "High precision rifles", 130, 1.1, "knife,deagle:50,ak47:200,hegrenade:2,flashbang,smokegrenade")
_sctf_classes.addClass("Silenced", "No Noisy guns", 110, 1.3, "knife,usp:200,tmp:200,flashbang:2")
_sctf_classes.addClass("Shotgunner", "Low distances effective", 130, 1.2, "knife,glock:200,m3:60,hegrenade:2,flashbang,smokegrenade")
_sctf_classes.addClass("Support", "Good for take care of our flag", 250, 0.8, "knife,deagle:100,m249:500,hegrenade:3,flashbang,smokegrenade:2")
_sctf_classes.addClass("Grenadier", "Blow up the enemys with explosives", 140, 1.0, "knife,deagle:200,hegrenade:20,flashbang:5,smokegrenade:5")
_sctf_classes.addClass("Ligth Sniper", "Clean the guys at high distances", 130, 1.0, "knife,fiveseven:100,scout:50,hegrenade,flashbang:2,smokegrenade:2")
_sctf_classes.addClass("Heavy Sniper", "Clean the guys at high distances", 170, 1.0, "knife,deagle:100,awp:50,hegrenade,flashbang:2,smokegrenade:2")
"""

# Stats Class
class Stats(object):
	__savePath = os.path.join(_sctf_opt['game_options']['path'], 'data','playerstats')
	def __init__(self):
		self.players = {}
	def exists(self, steamid):
		return self.players.has_key(steamid)
	def load(self):
		playerList = es.getUseridList()
		for userid in playerList:
			self.add(es.getplayersteamid(userid))
	def add(self, steamid):
		if self.exists(steamid) or steamid == "BOT":
			return False
		if not os.path.exists(self.__savePath):
			os.mkdir(self.__savePath)
		player_db = os.path.join(self.__savePath, steamid.replace(':', '_')+'.dat')
		if os.path.isfile(player_db): # Old Client
			player_stats = open(player_db)
			self.players[steamid] = cPickle.load(player_stats)
			player_stats.close()
			self.check(steamid)
		else: # New Client
			self.players[steamid] = {}
			self.check(steamid)
	def remove(self, steamid, andSave = True):
		if not self.exists(steamid):
			return False
		if andSave:
			self.save(steamid)
		del self.players[steamid]
		return True
	def clear(self):
		for k in self.players:
			self.save(self.players[k]['steamid'])
		self.players.clear()
	def save(self, steamid):
		player_db = open(os.path.join(self.__savePath, steamid.replace(':', '_')+'.dat'), 'w')
		cPickle.dump(self.players[steamid], player_db)
		player_db.close()
	def check(self, steamid):
		if not self.players[steamid].has_key('steamid'):
			self.players[steamid]['steamid'] = steamid
		if not self.players[steamid].has_key('lastConnect'):
			self.players[steamid]['lastConnect'] = datetime.date.today()
		elif int(sctf_remove_inactive_players_after) > 0:
			date = datetime.date.today() - datetime.timedelta(int(sctf_remove_inactive_players_after))
		if not self.players[steamid].has_key('flagsScored'):
			self.players[steamid]['flagsScored'] = 0
		if not self.players[steamid].has_key('flagsCaptured'):
			self.players[steamid]['flagsCaptured'] = 0
		if not self.players[steamid].has_key('flagsDropped'):
			self.players[steamid]['flagsDropped'] = 0
		if not self.players[steamid].has_key('flagsReturned'):
			self.players[steamid]['flagsReturned'] = 0
		if not self.players[steamid].has_key('spawns'):
			self.players[steamid]['spawns'] = 0
		if not self.players[steamid].has_key('deaths'):
			self.players[steamid]['deaths'] = 0
		if not self.players[steamid].has_key('kills'):
			self.players[steamid]['kills'] = 0
		if not self.players[steamid].has_key('points'):
			self.players[steamid]['points'] = 0
	def give(self, name, steamid, amount = 1, check = False):
		if not steamid or steamid == "BOT":
			return False
		if check:
			if not self.exists(steamid):
				return False
		if not sctf_stats:
			return False
		self.players[steamid][name] += amount
		return True
	def get(self, steamid):
		return self.players[steamid]
	
class Flag(object):
	def __init__(self, team, coord):
		self.defcoord = coord
		self.currentcoord = coord
		self.status = 0
		self.color = "Red" if team == 2 else "Blue"
		self.timedrop = FlagsMngr.getTimedrop()
		self.team = team
		self.otherteam = 2 if team == 3 else 3
		self.owner = 0
		self.x, self.y, self.z = coord.split(' ', 3)
		self.dx = 0
		self.dy = 0
		self.dz = 0
		self.ispeech = 0
		self.index = 0
		
		self.scorePoints = 0
	def isvalid(self):
		if self.defcoord == "0 0 0":
			return False
		return True
	def create(self):
		userid = es.getuserid()
		mdlPoleIndex = es.precachemodel("models/mapmodels/pole.mdl")
		converter = {}
		converter['sctf_blue_flag'] = es.precachemodel("models/mapmodels/flags.mdl") # Blue
		converter['sctf_red_flag'] = es.precachemodel("models/mapmodels/flags2.mdl") # Red
			
		x = float(self.x)
		y = float(self.y)
		z = float(self.z)
		boxname = "sctf_%s_flag" % self.color.lower()
		
		# Pole
		es.server.cmd("es_xprop_dynamic_create %s \"props_c17/fence01a.mdl\";es est_setentname server_var(eventscripts_lastgive) %s_pole" % (userid, boxname))
		lgindex = es.ServerVar('eventscripts_lastgive')
		es.setindexprop(lgindex, "CBaseEntity.m_nModelIndex", mdlPoleIndex)
		es.setindexprop(lgindex, "CBaseEntity.m_clrRender", -1)
		es.setindexprop(lgindex, "CBaseEntity.m_angRotation", "0,0,0")
		es.server.queuecmd("est_EntTeleport %s %f %f %f" % (lgindex, x, y, z))
		
		# Flag
		es.server.cmd("es_xprop_dynamic_create %s \"props_c17/fence01a.mdl\";es est_setentname server_var(eventscripts_lastgive) %s" % (userid, boxname))
		lgindex = int(es.ServerVar('eventscripts_lastgive'))
		es.setindexprop(lgindex, "CBaseEntity.m_nModelIndex", converter[boxname])
		es.setindexprop(lgindex, "CBaseEntity.m_clrRender", -1)
		es.setindexprop(lgindex, "CBaseEntity.m_angRotation", "0,0,0")
		es.server.queuecmd("est_EntTeleport %i %f %f %f;es_xfire %s %s addoutput \"targetname %s\"\;es_xfire %s %s SetAnimation flag_idle1" % (lgindex, x, y, z, userid, boxname, boxname, userid, boxname))
		self.index = lgindex;

		self.reset()
	def capture(self, userid, fromDrop = False):
		converter = {}
		converter[2] = "sctf_red_flag"
		converter[3] = "sctf_blue_flag"
		if es.exists("userid", userid):
			global _sctf_opt
			es.server.cmd("est_Box_Remove %s;est_SetEntityColor %i 0 0 0 0" % (converter[self.team], self.index))
			pname = es.getplayername(userid)
			psteamid = es.getplayersteamid(userid)
					
			revflagColor = "Blue"
			t_type = "capture"
			ct_type = "capture"
			if self.team == 3:
				revflagColor = "Red"
				ct_type = "taken"
			else:
				t_type = "taken"
					
			flagsoundT = _sctf_opt['game_sounds']["%s_flag_%s" % (revflagColor.lower(), t_type)]
			flagsoundCT = _sctf_opt['game_sounds']["%s_flag_%s" % (revflagColor.lower(), ct_type)]
			if flagsoundT is not None:
				myPlayerList = playerlib.getPlayerList("#t")
				for fuserid in myPlayerList:
					es.playsound(fuserid.userid, flagsoundT, 1.0)
			if flagsoundCT is not None:
				myPlayerList = playerlib.getPlayerList("#ct")
				for fuserid in myPlayerList:
					es.playsound(fuserid.userid, flagsoundCT, 1.0)
						
			es.centermsg("%s Team has the Flag! (%s)" % (revflagColor, pname))
			es.msg("\x04SCTF:\x03 %s\x01 Team has the Flag! (\x03%s\x01)" % (revflagColor, pname))
					
			if sctf_score_for_take_flag:
				es.server.queuecmd("est_KillAdd %s +%s" % (userid, sctf_score_for_take_flag))
				es.tell(userid, "\x04SCTF:\x01 You win\x03 %s\x01 Kill(s) for take the flag!" % sctf_score_for_take_flag)
				
			self.status = 1
			self.owner = userid
			self.timedrop = FlagsMngr.getTimedrop()
			self.drawSpeechIcon(userid)
			es.event("initialize", "sctf_flag")
			es.event("setint", "sctf_flag", "userid", userid)
			es.event("setstring", "sctf_flag", "team", revflagColor.lower())
			es.event("setint", "sctf_flag", "rason", 1)
			es.event("setstring", "sctf_flag", "rason_sz", "captured")
			es.event("fire", "sctf_flag")
					
			_sctf_stats.give('flagsCaptured', psteamid)
	def checkDrop(self):
		if not self.status == 2:
			return False
		if self.timedrop > -1:
			self.timedrop -= 1
		if self.timedrop == 0 or self.timedrop == -1:
			self.reset()
			es.centermsg("%s Flag returned! (Time)" % self.color)
			es.msg("\x04SCTF:\x03 %s\x01 Flag\x01 returned! (\x03Time\x01)" % self.color)
			soundToPlay = _sctf_opt['game_sounds'][self.color.lower() + "_flag_return"]
			if soundToPlay is not None:
				myPlayerList = playerlib.getPlayerList()
				for userid in myPlayerList:
					es.playsound(userid.userid, soundToPlay, 1.0)
			es.event("initialize", "sctf_flag")
			es.event("setint", "sctf_flag", "userid", 0)
			es.event("setstring", "sctf_flag", "team", self.color.lower())
			es.event("setint", "sctf_flag", "rason", 4)
			es.event("setstring", "sctf_flag", "rason_sz", "return")
			es.event("fire", "sctf_flag")
		return True
	def drop(self, userid, username):
		if not self.owner == userid:
			return False
		t_type = "drop"
		ct_type = "drop"
		if self.team == 2:
			ct_type = "lost"
		else:
			t_type = "lost"
			
		es.centermsg("%s Flag Lost! (%s)" % (self.color, username))
		es.msg("\x04SCTF:\x03 %s\x01 Flag Lost! (\x03%s\x01)" % (self.color, username))
			
		if self.ispeech > 0:
			es.server.cmd("es_xremove %i" %  self.ispeech)
		locx, locy, locz = es.getplayerlocation(userid)
		locz -= _sctf_opt['flag_maker']['drop']['z']
		self.currentcoord = "%s %s %s" % (locx, locy, locz)
		self.owner = 0
		self.status = 2
		self.dx = locx
		self.dy = locy
		self.dz = locz
		self.ispeech = 0
		
		x = float(locx)
		y = float(locy)
		z = float(locz)
		if sctf_score_for_drop_flag:
			es.server.queuecmd("est_KillAdd %s -%s" % (userid, sctf_score_for_drop_flag))
			es.tell(userid, "\x04SCTF:\x01 You lost\x03 %s\x01 Kill(s) for Flag Drop!" % sctf_score_for_drop_flag)
				
		es.server.queuecmd("est_EntTeleport %i %f %f %f;est_SetEntityColor %i 255 255 255 255;est_Box_Trigger #l sctf_%s_flag \"%f %f %f\" \"%f %f %f\"" % (self.index, x,y,z, self.index, self.color.lower(), x-15,y-15,z-5,x+15,y+15,z+70))
		
		flagsoundT = _sctf_opt['game_sounds']["%s_flag_%s" % (self.color.lower(), t_type)]
		flagsoundCT = _sctf_opt['game_sounds']["%s_flag_%s" % (self.color.lower(), ct_type)]
		myPlayerList = playerlib.getPlayerList("#ct")
		for fuserid in myPlayerList:
			es.playsound(fuserid.userid, flagsoundCT, 1.0)
		myPlayerList = playerlib.getPlayerList("#t")
		for fuserid in myPlayerList:
			es.playsound(fuserid.userid, flagsoundT, 1.0)
				
		_sctf_stats.give('flagsDropped', es.getplayersteamid(userid))
		return True				
	def freturn(self, userid = 0):
		if not self.owner:
			return False
		if not userid == self.owner:
			return False
		soundToPlay = _sctf_opt['game_sounds'][self.color.lower()+"_flag_return"]
		if soundToPlay is not None:
			myPlayerList = playerlib.getPlayerList()
			for userid in myPlayerList:
				es.playsound(userid.userid, soundToPlay, 1.0)
						
		es.centermsg("%s Flag returned! (Disconnected)" % self.color)
		es.msg("\x04SCTF:\x03 %s\x01 Flag\x01 returned! (\x03Disconnected\x01)" % self.color)
			
		revflagColor = "Blue"
		if self.team == 3:
			revflagColor = "Red"
			
		self.reset()
			
		es.event("initialize", "sctf_flag")
		es.event("setint", "sctf_flag", "userid", 0)
		es.event("setstring", "sctf_flag", "team", revflagColor.lower())
		es.event("setint", "sctf_flag", "rason", 4)
		es.event("setstring", "sctf_flag", "rason_sz", "return")
		es.event("fire", "sctf_flag")
	def overFlag(self, userid, userteam):
		global _sctf_opt
		if userteam == self.team: # check for score an captured flag
			if self.status == 0: # Allowed to score
				if _sctf_flagsMngr.playerHaveFlag(userid, self.otherteam): # That userid have the flag!
					pname = es.getplayername(userid)
					psteamid = es.getplayersteamid(userid)
						
					es.centermsg("%s Team Score! (%s)" % (self.color, pname))
					es.msg("\x04SCTF:\x03 %s\x01 Team Score! (\x03%s\x01)" % (self.color, pname))
					#todo if (server_var(sctf_flag_score_add_kills_for_team) != 0) then es est_KillAdd #t server_var(sctf_flag_score_add_kills_for_team)
					#todo es_msg #multi #green SCTF:#default Red Team Wins#lightgreen server_var(sctf_flag_score_add_kills_for_team)#default Points For Flag Score!
						
					es.emitsound("player", userid, "weapons/explode3.wav" ,1.0, 0.5)
					es.emitsound("player", userid, "weapons/explode4.wav" ,1.0, 0.5)
					es.emitsound("player", userid, "weapons/explode5.wav" ,1.0, 0.5)
						
					if sctf_sacrifice_for_score:
						es.server.queuecmd("est_slay %s\nest_deathAdd %s -1" % (userid,userid))
					if sctf_score_for_score_flag:
						es.server.queuecmd("est_KillAdd %s %s" % (userid, sctf_score_for_score_flag))
						es.tell(userid, "\x04SCTF:\x01 You win\x03 %s\x01 Kill(s) for\x03 Flag Score\x01!" % sctf_score_for_score_flag)
					self.scorePoints += 1
					_sctf_flagsMngr.resetFlags(self.otherteam)
					# todo es est_SetPlayerColor server_var(sctf_coord) 255 255 255 255

					es.event("initialize", "sctf_flag")
					es.event("setint", "sctf_flag", "userid", userid)
					es.event("setstring", "sctf_flag", "team", self.color.lower())
					es.event("setint", "sctf_flag", "rason", 2)
					es.event("setstring", "sctf_flag", "rason_sz", "score")
					es.event("fire", "sctf_flag")
						
					if _sctf_opt['game_options']['score_limit'] > 0 and self.scorePoints >= _sctf_opt['game_options']['score_limit']:
						endGame()
					else:
						scoreSound = _sctf_opt['game_sounds'][self.color.lower()+"_team_score"]
						if scoreSound is not None:
							myPlayerList = playerlib.getPlayerList()
							for fuserid in myPlayerList:
								es.playsound(fuserid.userid, scoreSound, 1.0)
								
					_sctf_stats.give('flagsScored', psteamid)
			elif self.status == 2: # Allowed to return dropped flag
				pteam = es.getplayerteam(self.color)
				pname = es.getplayername(self.color)
				psteamid = es.getplayersteamid(self.color)
				self.reset()
							
				soundToPlay = _sctf_opt['game_sounds'][self.color.lower()+"_flag_return"]
				if soundToPlay is not None:
					myPlayerList = playerlib.getPlayerList()
					for fuserid in myPlayerList:
						es.playsound(fuserid.userid, soundToPlay, 1.0)
						
				es.centermsg("%s Flag returned! (%s)" % (self.color, pname))
				es.msg("\x04SCTF:\x03 %s\x01 Flag\x01 returned! (\x03%s\x01)" % (self.color, pname))
				if sctf_score_for_return_flag:
					es.server.queuecmd("est_KillAdd %s %s" % (userid, sctf_score_for_return_flag)) 
					es.tell(self.color, "\x04SCTF:\x01 You won\x03 %s\x01 Kill(s) for Flag Return" % sctf_score_for_return_flag)
								
				es.event("initialize", "sctf_flag")
				es.event("setint", "sctf_flag", "userid", userid)
				es.event("setstring", "sctf_flag", "team", self.color.lower())
				es.event("setint", "sctf_flag", "rason", 4)
				es.event("setstring", "sctf_flag", "rason_sz", "return")
				es.event("fire", "sctf_flag")

				_sctf_stats.give('flagsReturned', psteamid)
		else: # Enemy team under flag
			self.capture(userid)
	def drawSpeechIcon(self, userid):
		if _sctf_opt['game_options']['round_end']:
			return None
		flagmodel = "extras/sctf/info_speech_%sflag.mdl" % self.color.lower()
		x,y,z = es.getplayerlocation(userid)
		z += 96
		entname = "sctf_"+self.color.lower()+"_flag_carrier"
		es.server.cmd("es_xprop_dynamic_create %s %s;es est_setentname server_var(eventscripts_lastgive) %s" % (userid,flagmodel, entname))
		entindex = int(es.ServerVar('eventscripts_lastgive'))
		es.setindexprop(entindex, "CBaseEntity.m_vecOrigin", "%s,%s,%s" % (x,y,z))
		es.server.cmd("es_xfire %s %s SetParent !activator;es_xfire %s %s SetAnimation idle;es_xfire %s %s addoutput \"angles 0 0 0\";es_xfire %s %s addoutput \"solid 0\"" % (userid, entname, userid, entname, userid, entname, userid, entname))
		self.ispeech = entindex
	def reset(self):
		if self.ispeech:
			entlist = es.createentitylist(self.ispeech)
			if (entlist[self.ispeech]['classname'] == 'prop_dynamic') if entlist else False:
				es.server.queuecmd('es_xremove %s' % self.ispeech)
		#	es.server.cmd("es_xremove %i" % self.ispeech)
		self.currentcoord = self.defcoord
		self.status = 0
		self.owner = 0
		self.dx = 0
		self.dy = 0
		self.dz = 0
		self.timedrop = FlagsMngr.getTimedrop()
		self.ispeech = 0
		x = float(self.x)
		y = float(self.y)
		z = float(self.z)
		boxname = "sctf_%s_flag" % self.color.lower()
		#if self.index > 0:
		#	nt.touchUnregister(self.index, touch_flag_callback)
		#	handles.append(nt.touchRegister(self.index, touch_flag_callback, False, "player"))
		#	es.msg(handles[0])
		es.server.queuecmd("est_Box_Remove %s;est_EntTeleport %i %s %s %s;est_SetEntityColor %i 255 255 255 255;est_Box_Trigger #l %s \"%f %f %f\" \"%f %f %f\"" % (boxname, self.index, self.x,self.y,self.z, self.index, boxname, x-15,y-15,z-5,x+15,y+15,z+70))
	def getStatusString(self):
		text = "%s Flag: " % self.color
		if self.status == 0:
			text += "Idle\\n"
		elif self.status == 2:
			text += "Drop"
			if self.timedrop > 0:
				text += " (%is)" % self.timedrop
			text += "\\n"
		elif self.owner > 0:
			pname = es.getplayername(self.owner)
			text += "%s\\n" % pname	
		text += "%s Team Score: %i" % (self.color, self.scorePoints)
		if _sctf_opt['game_options']['score_limit'] > 0:
			text += "/%i" % _sctf_opt['game_options']['score_limit']
		return text
		
class FlagsMngr(object):
	__FlagsFile = os.path.join(_sctf_opt['game_options']['data_path'],'sctf_ctf_info.ini')
	def __init__(self):
		self.FlagsInfo = ConfigObj(self.__FlagsFile)
		self.FlagBlue = None
		self.FlagRed = None
	def load(self): # Load flag coords from file
		self.FlagBlue = None
		self.FlagRed = None
		if not os.path.isfile(self.__FlagsFile):
			self.FlagsInfo.write()
		mapname = str(es.ServerVar('eventscripts_currentmap'))
		if self.FlagsInfo.has_key(mapname):
			if self.FlagsInfo[mapname].has_key('red'):
				self.FlagsInfo[mapname]['red'] = self.FlagsInfo[mapname]['red'].strip()
				self.addFlag(2, self.FlagsInfo[mapname]['red'])
			if self.FlagsInfo[mapname].has_key('blue'):
				self.FlagsInfo[mapname]['blue'] = self.FlagsInfo[mapname]['blue'].strip()
				self.addFlag(3, self.FlagsInfo[mapname]['blue'])
	def addFlag(self, team, coord): # add flag to game
		if team == 2:
			self.FlagRed = Flag(team, coord)
		elif team == 3:
			self.FlagBlue = Flag(team, coord)
	def isvalid(self): # Return true if CTF game is ready (2 flags set)
		if self.FlagRed == None or self.FlagBlue == None:
			return False
		return True
	def playerDisconnected(self, userid):
		if not self.isvalid():
			return False
		if self.FlagRed.freturn(userid):
			return True
		if self.FlagBlue.freturn(userid):
			return True
		return False
	def dropFlag(self, userid, username):
		if self.FlagRed:
			if self.FlagRed.drop(userid, username):
				return True
		if self.FlagBlue:
			if self.FlagBlue.drop(userid, username):
				return True
		return False
	def playerOverFlag(self, userid, team, flagteam):
		if flagteam == 2:
			self.FlagRed.overFlag(userid, team)
		elif flagteam == 3:
			self.FlagBlue.overFlag(userid, team)
	def getFlagScore(self, team):
		if team == 2:
			return self.FlagRed.scorePoints
		elif team == 3:
			return self.FlagBlue.scorePoints
		else:
			return {2 : self.FlagRed.scorePoints, 3 : self.FlagBlue.scorePoints}
	def playerHaveFlag(self, userid, enemyteam): # Check if a player have the enemy flag
		if enemyteam == 2:
			if self.FlagRed.owner == userid:
				return True
			return False
		elif enemyteam == 3:
			if self.FlagBlue.owner == userid:
				return True
			return False
		return False
	def createFlags(self, flagteam = 0):
		if not self.isvalid(): # Unable to create flags with invalid state
			return False
		if flagteam == 2:
			self.FlagRed.create()
			return True
		elif flagteam == 3:
			self.FlagBlue.create()
			return True
		self.FlagRed.create()
		self.FlagBlue.create()
		return True
	def resetFlags(self, flagteam = 0):
		if flagteam == 2:
			if not self.FlagRed:
				return False
			self.FlagRed.reset()
			return True
		elif flagteam == 3:
			if not self.FlagBlue:
				return False
			self.FlagBlue.reset()
			return True
		if self.FlagRed:
			self.FlagRed.reset()
		if self.FlagBlue:
			self.FlagBlue.reset()
		return True
	def setFlag(self, team, coord):
		color = FlagsMngr.teamToColor(team)
		mapname = str(es.ServerVar('eventscripts_currentmap'))
		if not self.FlagsInfo.has_key(mapname):
			self.FlagsInfo[mapname] = {}
		self.FlagsInfo[mapname][color.lower()] = coord
		self.FlagsInfo.write()
		
		es.msg("\x04SCTF:\x01 New \x03%s\x01 Flag placed on map (\x03%s\x01)" % (color, coord))
		
	def showStatusHud(self):
		text = "SCTF Status:"
		if _sctf_opt['game_options']['game_time'] > -1:
			text += " %is Left" % _sctf_opt['game_options']['game_time']
		text += "\\n"
		if self.FlagRed:
			text += self.FlagRed.getStatusString()
			text += "\\n"
		if self.FlagBlue:
			text += self.FlagBlue.getStatusString()
		#text += "\\n"
		lenit = len(text) - 2
		es.server.queuecmd("est_hsay #h %s" % text)
	def checkFlagsDrop(self):
		if self.FlagRed:
			self.FlagRed.checkDrop()
		if self.FlagBlue:
			self.FlagBlue.checkDrop()
		
	@staticmethod
	def getTimedrop():
		timedrop = int(sctf_drop_flag_time)
		if timedrop <= 0:
			timedrop = -99
		return timedrop
		
	@staticmethod
	def teamToColor(team):
		return 'Red' if team == 2 else 'Blue'


	
class DownloadMngr:
	def __init__(self):
		self.data = []
	def reset(self):
		self.data = []
	def add(self, file):
		if not file:
			return False
		if not os.path.isfile(file):
			es.dbgmsg(0, "SCTF: Unable to found '%s'" % file)
			return False
		es.stringtable('downloadables', file)
		return True
	def addByFile(self, file):
		if not file:
			return 0
		if not os.path.isfile(file):
			es.dbgmsg(0, "SCTF: Unable to found '%s'" % file)
			return 0
		f = open(file)
		if not f:
			es.dbgmsg(0, "SCTF: Unable to read '%s'" % file)
			return 0
		lines = f.readlines()
		i = 0
		if lines:
			for line in lines:
				if len(line) < 12:
					continue
				line = line.strip()
				line_array = line.split(None, 1)
				line = line_array[0]
				if len(line) >= 12 and line[0:2] <> "//" and line[0:1] <> "#":
					if not line in self.data:
						self.data.append(line)
						es.stringtable('downloadables', line)
						#es.dbgmsg(0, "SCTF: Added Download: %s" % line)
			es.dbgmsg(0, "SCTF: Added '%i' Downloads" % i)
		f.close()
		return len(self.data)
	def reAdd(self):
		for file in self.data:
			es.stringtable('downloadables', file)
		es.dbgmsg(0, "SCTF: ReAdded '%i' Downloads" % len(self.data))
	def exists(self, file):
		return (file in self.data)
	def count(self):
		return len(self.data)
	def printAll(self):
		i = 0
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, "Current Downloads: (%i)" % len(self.data))
		es.dbgmsg(0, " ")
		for file in self.data:
			i += 1;
			es.dbgmsg(0, "%i: %s" % (i, file))
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, " ")
		
class Admins:
	data = []
	def __init__(self, defFile):
		self.file = defFile
		global data
		data = []
	def reset(self, defFile = None):
		global data
		data = []
		
		if defFile is not None:
			self.file = defFile
	def load(self):
		if not self.file:
			return 0
		if not os.path.isfile(self.file):
			es.dbgmsg(0, "SCTF: Unable to found '%s'" % self.file)
			return 0
		f = open(self.file)
		if not f:
			es.dbgmsg(0, "SCTF: Unable to read '%s'" % self.file)
			return 0
		lines = f.readlines()
		if lines:
			global data
			data = []
			for steamid in lines:
				if len(steamid) < 11:
					continue
				steamid = steamid.upper()
				steamid = steamid.strip()
				steamid_array = steamid.split(None, 1)
				steamid = steamid_array[0]
				if len(steamid) >= 11 and steamid[0:2] <> "//" and steamid[0:1] <> "#" and steamid[0:6] == "STEAM_":
					if not steamid in data:
						data.append(steamid)
						es.dbgmsg(0, "SCTF: Added Admin: %s" % steamid)
		f.close()
		return len(data)
	def save(topText = None, toFile = None):
		filetoSave = self.file
		if toFile is not None:
			filetoSave = toFile
			
		f = open(filetoSave, 'w')
		if not f:
			return False
			
		toWrite = ""
			
		if topText is not None:
			toWrite = topText
			
		for steamid in data:
			toWrite = "%s\n%s" % (toWrite, steamid)
			
		f.write(toWrite)
		f.close()
			
		es.dbgmsg(0, "SCTF: Admin file sucessfully saved to '%s'" % filetoSave)
		return True
	def getIndex(self, steamid):
		if not steamid:
			return -1
		return data.index(steamid.upper())
	def isAdmin(self, steamid):
		if not steamid:
			return False
			
		#steamid = steamid.upper()
		return (steamid.upper() in data)
	def count(self):
		return len(data)
	def addAdmin(self, steamid):
		if not steamid:
			return False
		global data
		steamid = steamid.upper()
		steamid = steamid.strip()
		if len(steamid) >= 11 and steamid[0:6] == "STEAM_":
			if not steamid in data:
				data.append(steamid)
				es.dbgmsg(0, "SCTF: Added Admin: %s" % steamid)
			return True
		
		return False
	def delAdmin(self, steamid):
		index = getIndex(steamid)
		if index == -1:
			return False
		global data
		data.remove(index)
		es.dbgmsg(0, "SCTF: Removed Admin: %s" % steamid)
		return True
	def printAll(self):
		i = 0
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, "Current Admins: (%i)" % len(data))
		es.dbgmsg(0, " ")
		for steamid in data:
			i += 1;
			es.dbgmsg(0, "%i: %s" % (i, steamid))
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, " ")
		
_sctf_classes_opt = {2:{},3:{}}
class ClassMngr:
	def __init__(self):
		self.menucount = {2:0,3:0}
		self.menupages = {2:1,3:1}
	def reset(self):
		global _sctf_classes_opt
		_sctf_classes_opt.clear()
		_sctf_classes_opt = {2:{},3:{}}
		self.menucount = {2:0,3:0}
		self.menupages = {2:1,3:1}
	def addClass(self, name, desc, health, speed, weapons, team = "0", model = None):
		global _sctf_classes_opt
		
		iteam = 0
		if team[0:1] == "2" or team[0:1] == "t":
			iteam = 2
		elif team[0:1] == "3" or team[0:1] == "c":
			iteam = 3
			
		classMaker = {}
		classMaker['team'] = iteam
		classMaker['name'] = name
		classMaker['desc'] = desc
		classMaker['model'] = None
		if model:
			model = model.replace("/", "\\")
			if not model.startswith("models\\"):
				model = "models\\" + model
			if not model.endswith(".mdl"):
				model += ".mdl"
				
			if os.path.isfile(_sctf_opt['game_options']['game_path']+"\\"+model):
				classMaker['model'] = model
			
		classMaker['health'] = int(health)
		classMaker['speed'] = float(speed)
		classMaker['weaponsStr'] = weapons
		classMaker['weapons'] = {}
		weapons = weapons.strip()
		weapon_dict = weapons.split(",")
		windex = 0
		for item in weapon_dict:
			ammoSepIndex = item.find(":")
			classMaker['weapons'][windex] = {}
			if ammoSepIndex == -1:
				classMaker['weapons'][windex]['ammo'] = -1
				classMaker['weapons'][windex]['name'] = item
			else:
				ammoSepIndex += 1
				classMaker['weapons'][windex]['ammo'] = int(item[ammoSepIndex:])
				classMaker['weapons'][windex]['name'] = item[0:ammoSepIndex-1]
				
			if classMaker['weapons'][windex]['name'][0:5] != "item_":
				if classMaker['weapons'][windex]['name'][0:7] != "weapon_":
					classMaker['weapons'][windex]['name'] = "weapon_" + classMaker['weapons'][windex]['name']
			else:
				classMaker['weapons'][windex]['ammo'] = -1
			windex += 1
		"""
		index = len(_sctf_classes_opt)
		_sctf_classes_opt[index] = {}
		_sctf_classes_opt[index]['team'] = iteam
		_sctf_classes_opt[index]['name'] = name
		_sctf_classes_opt[index]['desc'] = desc
		_sctf_classes_opt[index]['model'] = None
		if model:
			model = model.replace("/", "\\")
			if not model.startswith("models\\"):
				model = "models\\" + model
			if not model.endswith(".mdl"):
				model += ".mdl"
				
			if os.path.isfile(_sctf_opt['game_options']['game_path']+"\\"+model):
				_sctf_classes_opt[index]['model'] = model
			
		_sctf_classes_opt[index]['health'] = int(health)
		_sctf_classes_opt[index]['speed'] = float(speed)
		_sctf_classes_opt[index]['weaponsStr'] = weapons
		_sctf_classes_opt[index]['weapons'] = {}
		weapons = weapons.strip()
		weapon_dict = weapons.split(",")
		windex = 0
		for item in weapon_dict:
			ammoSepIndex = item.find(":")
			_sctf_classes_opt[index]['weapons'][windex] = {}
			if ammoSepIndex == -1:
				_sctf_classes_opt[index]['weapons'][windex]['ammo'] = -1
				_sctf_classes_opt[index]['weapons'][windex]['name'] = item
			else:
				ammoSepIndex += 1
				_sctf_classes_opt[index]['weapons'][windex]['ammo'] = int(item[ammoSepIndex:])
				_sctf_classes_opt[index]['weapons'][windex]['name'] = item[0:ammoSepIndex-1]
				
			if _sctf_classes_opt[index]['weapons'][windex]['name'][0:5] != "item_":
				if _sctf_classes_opt[index]['weapons'][windex]['name'][0:7] != "weapon_":
					_sctf_classes_opt[index]['weapons'][windex]['name'] = "weapon_" + _sctf_classes_opt[index]['weapons'][windex]['name']
			else:
				_sctf_classes_opt[index]['weapons'][windex]['ammo'] = -1
			windex += 1
		"""
		if iteam == 0:
			_sctf_classes_opt[2][len(_sctf_classes_opt[2])] = classMaker
			_sctf_classes_opt[3][len(_sctf_classes_opt[3])] = classMaker
			self.menucount[2] += 1
			self.menucount[3] += 1
			if self.menucount[2] >= 8:
				self.menucount[2] = 1
				self.menupages[2] += 1
			if self.menucount[3] >= 8:
				self.menucount[3] = 1
				self.menupages[3] += 1
		else:
			_sctf_classes_opt[iteam][len(_sctf_classes_opt[iteam])] = classMaker
			self.menucount[iteam] += 1
			if self.menucount[iteam] >= 8:
				self.menucount[iteam] = 1
				self.menupages[iteam] += 1
		es.dbgmsg(0, "SCTF: Added Class: %s (%i HP) (%f Speed) to team '%i'\n[%s] (%s)\n" % (name, classMaker['health'], classMaker['speed'], iteam, desc, classMaker['weaponsStr']))
	def removeClass(self, name):
		return None # Not implemented
		global _sctf_classes_opt
		for index in _sctf_classes_opt:
			if _sctf_classes_opt[index]['name'] == name:
				del _sctf_classes_opt[index]
	def randomClass(self, team):
		classeslen = len(_sctf_classes_opt[team])
		if classeslen  <= 0:
			return -1
		return random.randint(0, classeslen)
	def applyClass2Player(self, userid, team, index):
		if not _sctf_classes_opt[team].has_key(index):
			return False
		if len(_sctf_classes_opt[team][index]['weapons']) <= 0:
			return False
		es.server.cmd("est_StripPlayer %s" % userid)
		for windex in _sctf_classes_opt[team][index]['weapons']:
			es.server.cmd("es_xgive %s %s" % (userid, _sctf_classes_opt[team][index]['weapons'][windex]['name']))
			if _sctf_classes_opt[team][index]['weapons'][windex]['ammo'] >= 0:
				es.server.queuecmd("est_SetAmmo %s %s %i" % (userid, _sctf_classes_opt[team][index]['weapons'][windex]['name'], _sctf_classes_opt[team][index]['weapons'][windex]['ammo']))
		es.setplayerprop(userid, "CBasePlayer.m_iHealth", _sctf_classes_opt[team][index]['health'])
		es.setplayerprop(userid, "CBasePlayer.localdata.m_flLaggedMovementValue", _sctf_classes_opt[team][index]['speed'])
		if _sctf_classes_opt[team][index]['model']:
			es.setplayerprop(userid, "CBaseEntity.m_nModelIndex", es.precachemodel(_sctf_classes_opt[team][index]['model']))
			playerlib.getPlayer(userid).set('color', ['255', '255', '255', '255'])
	def indexByName(self, team, name):
		for index in _sctf_classes_opt:
			if _sctf_classes_opt[team][index]['name'] == name:
				return index
	def getMenuPages(self, team):
		return self.menupages[team]
	def getMenuCount(self, team):
		return self.menucount[team]
	def isValidIndex(self, index, team):
		return _sctf_classes_opt[team].has_key(index)
	def copy(self):
		return _sctf_classes_opt
	def count(self, team):
		return len(_sctf_classes_opt[team])
	def printAll(self):
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, "Current Classes: (Team 2: %i | Team 3: %i)" % (len(_sctf_classes_opt[2]), len(_sctf_classes_opt[3])))
		es.dbgmsg(0, "TEAM 2:")
		for index in _sctf_classes_opt[2]:
			es.dbgmsg(0, "%i: %s (%i HP) (%s Speed)\n[%s] (%s)\nModel: %s\n" % (index+1, _sctf_classes_opt[2][index]['name'], _sctf_classes_opt[2][index]['health'], str(_sctf_classes_opt[2][index]['speed']), _sctf_classes_opt[2][index]['desc'], _sctf_classes_opt[2][index]['weaponsStr'], _sctf_classes_opt[2][index]['model']))
		es.dbgmsg(0, "\n------------------------------------\nTEAM 3:\n\n")
		for index in _sctf_classes_opt[3]:
			es.dbgmsg(0, "%i: %s (%i HP) (%s Speed)\n[%s] (%s)\nModel: %s\n" % (index+1, _sctf_classes_opt[3][index]['name'], _sctf_classes_opt[3][index]['health'], str(_sctf_classes_opt[3][index]['speed']), _sctf_classes_opt[3][index]['desc'], _sctf_classes_opt[3][index]['weaponsStr'], _sctf_classes_opt[3][index]['model']))
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, " ")

		
_sctf_stats = Stats()
_sctf_flagsMngr = FlagsMngr()
_sctf_admins = Admins(os.path.join(_sctf_opt['game_options']['config_path'],"sctf_admins.txt"))
_sctf_classes = ClassMngr()

def reset(isLoad = False):
	global _sctf_opt
	global _sctf_players
	sctf_version.set(info.version)
	sctf.set("1")
	
	es.stringtable('downloadables', 'models/mapmodels/flags.dx80.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags.dx90.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags.mdl')
	es.stringtable('downloadables', 'models/mapmodels/flags.sw.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags.vvd')
	#es.stringtable('downloadables', 'models/mapmodels/flags.xbox.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags2.dx80.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags2.dx90.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags2.mdl')
	es.stringtable('downloadables', 'models/mapmodels/flags2.sw.vtx')
	es.stringtable('downloadables', 'models/mapmodels/flags2.vvd')
	es.stringtable('downloadables', 'models/mapmodels/flags2.xbox.vtx')
	es.stringtable('downloadables', 'models/mapmodels/pole.dx80.vtx')
	es.stringtable('downloadables', 'models/mapmodels/pole.dx90.vtx')
	es.stringtable('downloadables', 'models/mapmodels/pole.mdl')
	es.stringtable('downloadables', 'models/mapmodels/pole.sw.vtx')
	es.stringtable('downloadables', 'models/mapmodels/pole.vvd')
	es.stringtable('downloadables', 'models/mapmodels/pole.xbox.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.dx80.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.dx90.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.mdl')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.sw.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.vvd')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.phy')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_blueflag.xbox.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.dx80.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.dx90.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.mdl')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.sw.vtx')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.vvd')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.phy')
	es.stringtable('downloadables', 'models/extras/sctf/info_speech_redflag.xbox.vtx')
	# Meterials
	es.stringtable('downloadables', 'materials/models/mapmodels/flags/axisflag.vmt')
	es.stringtable('downloadables', 'materials/models/mapmodels/flags/axisflag.vtf')
	es.stringtable('downloadables', 'materials/models/mapmodels/flags/neutralflag.vmt')
	es.stringtable('downloadables', 'materials/models/mapmodels/flags/neutralflag.vtf')
	es.stringtable('downloadables', 'materials/models/extras/sctf/speech_info_blueflag.vmt')
	es.stringtable('downloadables', 'materials/models/extras/sctf/speech_info_blueflag.vtf')
	es.stringtable('downloadables', 'materials/models/extras/sctf/speech_info_redflag.vmt')
	es.stringtable('downloadables', 'materials/models/extras/sctf/speech_info_redflag.vtf')
	
	DownloadMngr().addByFile(os.path.join(_sctf_opt['game_options']['config_path'],"sctf_downloads.txt"))
	if not os.path.isdir(_sctf_opt['game_options']['data_path']):
		os.mkdir(_sctf_opt['game_options']['data_path'])
	if sctf_map_config:
		mapfile = os.path.join(_sctf_opt['game_options']['config_path'], 'maps', str(es.ServerVar('eventscripts_currentmap'))+'.cfg')
		if os.path.isfile(mapfile):
			es.server.cmd("es_xmexec ..%s" % mapfile.replace(_sctf_opt['game_options']['game_path'], '', 1))
	_sctf_classes.reset()
	es.server.cmd("es_xmexec ../%s/sctf_sounds.cfg;es_xmexec ../%s/sctf_models.cfg" % (_sctf_opt['game_options']['config_short_path'], _sctf_opt['game_options']['config_short_path']))

	if sctf_remove_time:
		entlist = es.createentitylist()
		for index in entlist:
			if entlist[index]['classname'] == "func_hostage_rescue" or entlist[index]['classname'] == "func_bomb_target":
				es.server.queuecmd('es_xremove %s' % index)
	
	gamethread.cancelDelayed("clean_idle")
	gamethread.cancelDelayed("repeat1s")
	_sctf_players.clear()
	_sctf_players = {}
	_sctf_opt['game_options']['game_time'] = -99
	_sctf_opt['game_options']['score_limit'] = -99
	if int(sctf_game_time) >= 5:
		_sctf_opt['game_options']['game_time'] = int(sctf_game_time)
	if sctf_score_limit:
		_sctf_opt['game_options']['score_limit'] = int(sctf_score_limit)
	
	# Sounds
	temp_sound_array = []
	for key in _sctf_opt['game_sounds']:
		if str(es.ServerVar("sctf_sound_" + key)) and len(str(es.ServerVar("sctf_sound_" + key))) > 3 and (str(es.ServerVar("sctf_sound_" + key)).endswith(".wav") or str(es.ServerVar("sctf_sound_" + key)).endswith(".mp3")):
			_sctf_opt['game_sounds'][key] = str(es.ServerVar("sctf_sound_" + key))
			if not _sctf_opt['game_sounds'][key] in temp_sound_array:
				temp_sound_array.append(_sctf_opt['game_sounds'][key])
				es.dbgmsg(0, "SCTF: Sound added to download: sound/%s" % (_sctf_opt['game_sounds'][key]))
				es.server.queuecmd("downloadable sound/%s" % (_sctf_opt['game_sounds'][key]))
		else:
			_sctf_opt['game_sounds'][key] = None
	#if len(sctf_sound_blue_flag_taken) > 3 and (str(sctf_sound_blue_flag_taken).endswith(".wav") or str(sctf_sound_blue_flag_taken).endswith(".mp3"))
	
	_sctf_flagsMngr.load()

	es.loadevents("declare", os.path.join(_sctf_opt['game_options']['data_path'],"sctf_events.res"))

	#Assert time
	if int(sctf_clean_ground_time) < 1 or int(sctf_clean_ground_time) > 180:
		sctf_clean_ground_time.set(random.randint(1, 180))
		
	_sctf_opt['game_options']['clean_idle'] = float(sctf_clean_ground_time)	
	gamethread.delayedname(_sctf_opt['game_options']['clean_idle'], "clean_idle", sctf_delayed_funcs, ("clean"))
	gamethread.delayedname(1, "repeat1s", sctf_delayed_funcs, ("repeat1s"))
	sctf_load_admins()
	
def requirements():
	if not es.exists("variable", "est_version"):
		return False
	if not es.exists("variable", "nativetools_ver"):
		return False
	return True
def cmdfilter(userid, args):
	if args[0].lower() == "drop":
		if sctf_restrict_drop:
			es.tell(userid, "\x04SCTF:\x01 You cant drop your weapons!")
			return False
	return True
		
def load():
	sctf_version.makepublic() 
	sctf.makepublic()
	if not requirements():
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, "Eventscripts (ES): PASSED [%s]" % str(es.ServerVar("eventscripts_ver")))
		es.dbgmsg(0, "EsTools (EST):     FAIL")
		es.dbgmsg(0, " ")
		es.dbgmsg(0, "Script will be unloaded, because not meat the REQUIREMENTS!")
		es.dbgmsg(0, "Please repair or load missing requirement if you haveit")
		es.dbgmsg(0, "Fail requirement can be downloaded at:")
		es.dbgmsg(0, "http://forums.mattie.info/cs/forums/viewtopic.php?t=3413")
		es.dbgmsg(0, "----------------SCTF----------------")
		es.dbgmsg(0, " ")
		es.server.queuecmd("es_unload sctf")
		return False
	
	if not es.exists("command", "sctf_reload_admins"):
		es.regcmd('sctf_reload_admins', 'sctf/sctf_load_admins', 'Reload admins.')
	if not es.exists("command", "sctf_print_admins"):
		es.regcmd('sctf_print_admins', 'sctf/sctf_print_admins', 'Print all admins.')
	if not es.exists("command", "sctf_set_timeleft"):
		es.regcmd('sctf_set_timeleft', 'sctf/sctf_set_timeleft', 'Set timeleft for game end (SCTF Clock).')
	if not es.exists("command", "sctf_print_classes"):
		es.regcmd('sctf_print_classes', 'sctf/sctf_print_classes', 'Print all classes.')
	if not es.exists("command", "sctf_clean_classes"):
		es.regcmd('sctf_clean_classes', 'sctf/sctf_clean_classes', 'Removes all classes.')
	if not es.exists("command", "sctf_set_scorelimit"):
		es.regcmd('sctf_set_scorelimit', 'sctf/sctf_set_scorelimit', 'Set score limit for game (Flag Score).')
	if not es.exists("command", "sctf_add_class"):
		es.regcmd('sctf_add_class', 'sctf/sctf_add_class', 'Add a new class to game.')
	if not es.exists("saycommand", "setflag"):
		es.regsaycmd('setflag', 'sctf/sctf_setflag', 'Set a flag in player location.')
		
	es.server.cmd("alias None \" \";es_xmexec ../%s/sctf_server.cfg;es_xmexec ../%s/sctf_on_load.cfg" % (_sctf_opt['game_options']['config_short_path'], _sctf_opt['game_options']['config_short_path']))
	es.addons.registerClientCommandFilter(cmdfilter)

	if len(str(es.ServerVar('eventscripts_currentmap'))) > 1:
		reset(True)
		global _sctf_players
		myPlayerList = playerlib.getPlayerList()
		for userid in myPlayerList:
			_sctf_players[userid.userid] = {}
			_sctf_players[userid.userid]['menu'] = 0
			_sctf_players[userid.userid]['menupage'] = 0
			_sctf_players[userid.userid]['class'] = -1
		_sctf_stats.load()
#		es.msg("\x04SCTF:\x01 Loading player stats")
		es.server.queuecmd("est_slay #l")
		es.msg("\x04SCTF:\x01 Killing all players to refresh\x03 CTF\x01")
	
def unload():
	sctf.set("0")
	es.server.cmd("es_xmexec ../%s/sctf_on_unload.cfg" % _sctf_opt['game_options']['config_short_path'])
	
	es.unregsaycmd("setflag")
	es.addons.unregisterClientCommandFilter(cmdfilter)

	
	gamethread.cancelDelayed("clean_idle")
	gamethread.cancelDelayed("repeat1s")
	
	_sctf_stats.clear()
	
def es_map_start(event_var):
	reset()
	if sctf_stats and sctf_remove_inactive_players_after:
		date = datetime.date.today() - datetime.timedelta(int(sctf_remove_inactive_players_after))
		es.dbgmsg(0, "SCTF: Removing inactive players util: %s" % date) 

def player_activate(event_var):
	gamethread.delayed(10, sctf_delayed_funcs, ("welcome", event_var['userid']))

	global _sctf_players
	userid = int(event_var['userid'])
	_sctf_players[userid] = {}
	_sctf_players[userid]['menu'] = 0
	_sctf_players[userid]['menupage'] = 0
	_sctf_players[userid]['class'] = -1
	_sctf_stats.add(event_var['es_steamid'])
			
def player_team(event_var):
	global _sctf_players
	if int(event_var['team']) > 1:
		userid = int(event_var['userid'])
		_sctf_players[userid] = {}
		_sctf_players[userid]['menu'] = 0
		_sctf_players[userid]['menupage'] = 0
		_sctf_players[userid]['class'] = -1
		gamethread.delayed(3, sctf_delayed_funcs, ("autorespawn", userid))

def es_client_command(event_var):
	#if (event_var(command) = "!sctfclasses") then if (server_var(sctf_classes) = 1) then es_xdoblock sctf/sctf_classes_menu
	if event_var['command'] == "menuselect":
		if _sctf_players[int(event_var['userid'])]['menu'] == 1:
			sctf_handle_classes_menu(event_var['userid'], int(event_var['es_userteam']), event_var['commandstring'])
			return None

def round_start(event_var):
	global _sctf_opt
	_sctf_opt['game_options']['round_end'] = False
	if sctf_show_flags:
		_sctf_flagsMngr.load()
		_sctf_flagsMngr.createFlags()
	es.msg("\x04SCTF:\x01 Lets move guys, protect own\x03 Flag\x01 And capture the enemy\x03 Flag\x01!")
	if sctf_remove_time:
		entlist = es.createentitylist()
		for index in entlist:
			if entlist[index]['classname'] == "func_hostage_rescue" or entlist[index]['classname'] == "func_bomb_target":
				es.server.queuecmd('es_xremove %s' % index)


def round_end(event_var):
	global _sctf_opt
	_sctf_opt['game_options']['round_end'] = True
	#es.server.cmd("est_slay #l")
	_sctf_flagsMngr.resetFlags()

def player_spawn(event_var):
	if int(event_var['es_userteam']) > 1:
		global _sctf_players
		userid = int(event_var['userid'])
		if sctf_remove_money:
			es.setplayerprop(event_var['userid'], "CCSPlayer.m_iAccount", 0)
		_sctf_stats.give('spawns', event_var['es_steamid'])
		
		if sctf_use_classes:
			if _sctf_classes.count(int(event_var['es_userteam'])):
				if _sctf_players[userid]['class'] == -1:
					if not event_var['es_steamid'] == "BOT":
						sctf_send_classes_menu(userid, 0)
					else:
						_sctf_players[userid]['class'] = _sctf_classes.randomClass(int(event_var['es_userteam']))
						_sctf_classes.applyClass2Player(userid, int(event_var['es_userteam']), _sctf_players[userid]['class'])
				else:
					_sctf_classes.applyClass2Player(userid, int(event_var['es_userteam']), _sctf_players[userid]['class'])

def player_disconnect(event_var):
	_sctf_stats.remove(event_var['es_steamid'])
	if int(event_var['es_userteam']) <= 1:
		return
	
	del _sctf_players[int(event_var['userid'])]
	_sctf_flagsMngr.playerDisconnected(int(event_var['userid']))

#def sctf_flag(event_var):
#	es.msg("Userid: %s | team: %s | rason: %s | rasonSZ: %s" % (event_var['userid'], event_var['team'], event_var['rason'], event_var['rason_sz']))
	
def player_death(event_var):
	if int(event_var['es_userteam']) <= 1:
		return
	_sctf_flagsMngr.dropFlag(int(event_var['userid']), event_var['es_username'])
	if sctf_remove_money:
		es.setplayerprop(event_var['userid'], "CCSPlayer.m_iAccount", 0)
	if sctf_use_classes:
		if random.randint(0, 10) == 5:
			es.tell(event_var['userid'], "\x04SCTF:\x01 Say\x03 class\x01 to change you class!")
	if sctf_auto_spawn:
		if float(sctf_spawn_delay) >= 1.0:
			gamethread.delayed(float(sctf_spawn_delay), sctf_delayed_funcs, ("autorespawn", int(event_var['userid'])))
		else:
			nt.spawnPlayer(event_var['userid'])
	es.server.queuecmd("est_RemoveIdle weapon_;est_RemoveIdle item_")
	_sctf_stats.give('deaths', event_var['es_steamid'])
	if not event_var['userid'] == event_var['attacker']:
		_sctf_stats.give('kills', event_var['es_attackersteamid'])

def player_say(event_var):
	if event_var['es_steamid'] == "BOT":
		return None
	if event_var['text'][0:5] == "class":
		if sctf_use_classes:
			userid = int(event_var['userid'])
			_sctf_players[userid]['menupage'] = 0
			sctf_send_classes_menu(event_var['userid'])
		else:
			es.tell(event_var['userid'], "\x04SCTF:\x01 Classes are currently\x03 disabled\x01!")
		return None
	if event_var['text'][0:8] == "flagstat":
		if sctf_stats:
			playerStats = _sctf_stats.get(event_var['es_steamid'])
			es.menu(0, event_var['userid'], "SCTF v%s <-> By Sn4k3\\n \\nMy Stats:\\n->1. Spawns: %i\\n->2. Deaths: %i\\n->3. Kills: %i\\n->4. Flags Captured: %i\\n->5. Flags Score: %i\\n->6. Flags Drop: %i\\n->7. Flags Return: %i\\n \\n0. Exit" % (str(sctf_version), playerStats['spawns'], playerStats['deaths'], playerStats['kills'], playerStats['flagsCaptured'], playerStats['flagsScored'], playerStats['flagsDropped'], playerStats['flagsReturned']))
		else:
			es.tell(event_var['userid'], "\x04SCTF:\x01 Stats is currently disabled")
		return None
	
def est_box_trigger(event_var):
	if not (event_var['boxname'] == "sctf_red_flag" or event_var['boxname'] == "sctf_blue_flag"):
		return None
	flagteam = 2 if event_var['boxname'] == "sctf_red_flag" else 3
	_sctf_flagsMngr.playerOverFlag(int(event_var['userid']), int(event_var['es_userteam']), flagteam)
######################################################################
	
def sctf_send_classes_menu(userid, time = 0):
	userid = int(userid)
	team = int(es.getplayerteam(userid))
	if not team:
		return None
	if len(_sctf_classes_opt[team]) == 0:
		es.tell(userid, "\x04SCTF:\x01 There are no\x03 Classes\x01 created")
		return None
	global _sctf_players
	_sctf_players[userid]['menu'] = 1
	menu_str = "SCTF v%s <-> By Sn4k3\\nClasses (%i/%i):\\n \\n" % (str(info.version), _sctf_players[userid]['menupage']+1, _sctf_classes.getMenuPages(team))
	i = 0
	index = 7*_sctf_players[userid]['menupage']
	keys = "0"
	userid = int(userid)
	lenClasses = len(_sctf_classes_opt[team])
	while index < lenClasses:
	#for index in _sctf_classes_opt:
		i += 1
		menu_str += "->%i. %s [%i HP] [%s Speed]\\n%s\\n" % (i, _sctf_classes_opt[team][index]['name'], _sctf_classes_opt[team][index]['health'], str(_sctf_classes_opt[team][index]['speed']), _sctf_classes_opt[team][index]['desc'])
		keys += "%i" % i
		index += 1
		if i == 7:
			break
	
	if _sctf_players[userid]['menupage'] > 0:
		keys += "8"
		menu_str += " \\n->8. Back"
	else:
		menu_str += " \\n8. Back"
	if lenClasses > index:
		keys += "9"
		menu_str += "\\n->9. Next"
	else:
		menu_str += "\\n9. Next"
	menu_str += "\\n0. Random"
	es.menu(time, userid, menu_str, keys)
	
def sctf_handle_classes_menu(userid, team, num):
	global _sctf_players
	userid = int(userid)
	num = int(num)
	oldClass = _sctf_players[userid]['class']
		
	if num == 8:
		es.playsound(userid, _sctf_opt['dev_sounds']['menuback'], 1.0)
		_sctf_players[userid]['menupage'] -= 1
		sctf_send_classes_menu(userid, 0)
		return True
	elif num == 9:
		es.playsound(userid, _sctf_opt['dev_sounds']['menunext'], 1.0)
		_sctf_players[userid]['menupage'] += 1
		sctf_send_classes_menu(userid, 0)
		return True
	elif num == 10:
		es.playsound(userid, _sctf_opt['dev_sounds']['menuselect'], 1.0)
		_sctf_players[userid]['menu'] = 0
		_sctf_players[userid]['class'] = _sctf_classes.randomClass(team)
	else:
		es.playsound(userid, _sctf_opt['dev_sounds']['menuselect'], 1.0)
		_sctf_players[userid]['menu'] = 0
		_sctf_players[userid]['class'] = 7*_sctf_players[userid]['menupage']+num-1
		if not _sctf_classes.isValidIndex(_sctf_players[userid]['class'], team):
			_sctf_players[userid]['class'] = -1

	if oldClass >= 0:
		es.tell(userid, "\x04SCTF:\x01 You will respawn as\x03 %s\x01" % _sctf_classes_opt[team][_sctf_players[userid]['class']]['name'])
		return True	
	if playerlib.getPlayer(userid).attributes['isdead']: # user is dead
		es.tell(userid, "\x04SCTF:\x01 You will respawn as\x03 %s\x01" % _sctf_classes_opt[team][_sctf_players[userid]['class']]['name'])
		return True
		
	_sctf_classes.applyClass2Player(userid, team, _sctf_players[userid]['class'])
	
def sctf_status_to_string(status):
	if status == 0:
		return "UnCaptured"
	elif status == 1:
		return "Captured"
	else:
		return "Drop"

def sctf_add_class():
	if es.getargv() <= 7:
		es.dbgmsg(0, "Syntax: %s <name> <description> <health> <speed> <\"weapons:ammo\"> [team] [model]" % es.getargv(0))
		return None
	name = es.getargv(1)
	desc = es.getargv(2)
	health = int(es.getargv(3))
	speed = float(es.getargv(4))
	weapons = es.getargv(5)
	team = es.getargv(6)
	model = es.getargv(7)
	if not model:
		model = None
	_sctf_classes.addClass(name, desc, health, speed, weapons, team, model)
	
def sctf_clean_classes():
	_sctf_classes.reset()

def sctf_load_admins():
	_sctf_admins.load()
	
def sctf_print_admins():
	_sctf_admins.printAll()
	
def sctf_print_classes():
	_sctf_classes.printAll()
	
def sctf_setflag():
	userid = es.getcmduserid()
	steamid = es.getplayersteamid(userid)
	if not _sctf_admins.isAdmin(steamid):
		es.tell(userid, "\x04SCTF:\x01 You are not autorized to use admin commands (\x03%s\x01)" % es.getargv(0))
		return

	if playerlib.getPlayer(userid).get("isdead"):
		es.tell(userid, "\x04SCTF:\x01 You must be alive to use that command (\x03%s\x01)" % es.getargv(0))
		return
	x, y, z = es.getplayerlocation(userid)
	argv = es.getargv(1)
	team = 3
	if argv[0:1] == "2" or argv[0:1] == "t" or argv[0:1] == "r":
		team = 2
	elif argv[0:1] == "3" or argv[0:1] == "c" or argv[0:1] == "b":
		team = 3
	else:
		team = int(es.getplayerteam(userid))
	_sctf_flagsMngr.setFlag(team, "%s %s %s" % (x, y, z))
	
def sctf_set_timeleft():
	if es.getargc() <= 1:
		es.dbgmsg(0, "Syntax: %s <Time in Minutes (Lessthan 1 = Disable)>" % es.getargv(0))
		return
	argv = float(es.getargv(1))
	if argv >= 1:
		_sctf_opt['game_options']['game_time'] = argv*60
	else:
		_sctf_opt['game_options']['game_time'] = -99
		
		
def sctf_set_scorelimit():
	if es.getargc() <= 1:
		es.dbgmsg(0, "Syntax: %s <Score (Lesstan 1 = Disable)>" % es.getargv(0))
		return
	argv = int(es.getargv(1))
	if argv >= 1:
		_sctf_opt['game_options']['score_limit'] = argv
	else:
		_sctf_opt['game_options']['score_limit'] = -99
		
def endGame():
	userid = int(es.getuserid())
	es.server.cmd("es_xgive %i game_end;es_xfire %i game_end EndGame" % (userid,userid))
	
	es.event("initialize", "sctf_gameend")
	if _sctf_opt['game_options']['game_time'] == -99:
		es.event("setint", "sctf_gameend", "timeleft", -1)
	else:
		es.event("setint", "sctf_gameend", "timeleft", _sctf_opt['game_options']['game_time'])

	flagsScore = _sctf_flagsMngr.getFlagsScore()
	if flagsScore[3] > flagsScore[2]: # blues win
		es.event("setint", "sctf_gameend", "winners", 3)
		es.event("setint", "sctf_gameend", "winners_score", flagsScore[3])
		es.event("setint", "sctf_gameend", "lossers", 2)
		es.event("setint", "sctf_gameend", "lossers_score", flagsScore[2])
		es.event("setint", "sctf_gameend", "draw", 0)
		es.msg("\x04SCTF:\x01 \x03Blue Team\x01 was won the match! (\x03%i\x01-\x03%i\x01)" % (flagsScore[3], flagsScore[2]))
		if _sctf_opt['game_sounds']['blue_team_wins'] is not None:
			myPlayerList = playerlib.getPlayerList("#ct")
			for userid in myPlayerList:
				es.playsound(userid.userid, _sctf_opt['game_sounds']['blue_team_wins'], 1.0)
		if _sctf_opt['game_sounds']['red_team_lose'] is not None:
			myPlayerList = playerlib.getPlayerList("#t")
			for userid in myPlayerList:
				es.playsound(userid.userid, _sctf_opt['game_sounds']['red_team_lose'], 1.0)
	elif flagsScore[3] < flagsScore[2]: # reds win
		es.event("setint", "sctf_gameend", "winners", 2)
		es.event("setint", "sctf_gameend", "winners_score", flagsScore[2])
		es.event("setint", "sctf_gameend", "lossers", 3)
		es.event("setint", "sctf_gameend", "lossers_score", flagsScore[3])
		es.event("setint", "sctf_gameend", "draw", 0)
		es.msg("\x04SCTF:\x01 \x03Red Team\x01 was won the match! (\x03%i\x01-\x03%i\x01)" % (flagsScore[2], flagsScore[3]))
		if _sctf_opt['game_sounds']['red_team_wins'] is not None:
			myPlayerList = playerlib.getPlayerList("#t")
			for userid in myPlayerList:
				es.playsound(userid.userid, _sctf_opt['game_sounds']['red_team_wins'], 1.0)
		if _sctf_opt['game_sounds']['blue_team_lose'] is not None:
			myPlayerList = playerlib.getPlayerList("#ct")
			for userid in myPlayerList:
				es.playsound(userid.userid, _sctf_opt['game_sounds']['blue_team_lose'], 1.0)
	elif flagsScore[3] == flagsScore[2]: # draw
		es.event("setint", "sctf_gameend", "winners", 0)
		es.event("setint", "sctf_gameend", "winners_score", flagsScore[3])
		es.event("setint", "sctf_gameend", "lossers", 0)
		es.event("setint", "sctf_gameend", "lossers_score", flagsScore[2])
		es.event("setint", "sctf_gameend", "draw", 1)
		es.msg("\x04SCTF:\x01 Game end in a \x03Draw\x01! (\x03%i\x01-\x03%i\x01)" % (flagsScore[2], flagsScore[3]))
		if _sctf_opt['game_sounds']['draw'] is not None:
			myPlayerList = playerlib.getPlayerList()
			for userid in myPlayerList:
				es.playsound(userid.userid, _sctf_opt['game_sounds']['draw'], 1.0)

	es.event("fire", "sctf_gameend")
	

def touch_flag_callback(index, touched):
	playeruserid = nt.getUseridByIndex(touched)
	es.msg("Touch!")
	if(playeruserid > 0):
		if es.exists("userid", playeruserid):
			es.msg("#multi", "#lightgreen[NativeTools]#default %s#green touched#default %s" % (es.getplayername(playeruserid), es.getplayername(playeruserid)))


def drawFlags():
	for flag in _sctf_opt['flags']:
		if not _sctf_opt['flags'][flag].has_key('defcoord'):
			continue
		if _sctf_opt['flags'][flag]['defcoord'] == "0 0 0":
			continue
	
		rgba = None
		defrgba = None
		glowMaterial = "sprites/blueglow1.vmt"
		if _sctf_opt['flags'][flag]['team'] == 2:
			defrgba = "255 0 0 255"
			glowMaterial = "sprites/purpleglow1.vmt"
		else:
			defrgba = "0 0 255 255"
			
		rgba = defrgba
		if _sctf_opt['flags'][flag]['status'] > 0:
			rgba = "255 255 255 255"
		
		
		z1 = _sctf_opt['flags'][flag]['z'] + _sctf_opt['flag_maker']['live']['z1']
		z2 = z1 - _sctf_opt['flag_maker']['live']['z2']
		x1 = _sctf_opt['flags'][flag]['x'] + _sctf_opt['flag_maker']['live']['x1']
		es.server.cmd("est_Effect 11 #h 0 %s %s %f 1 255" % (glowMaterial, _sctf_opt['flags'][flag]['defcoord'], _sctf_opt['flag_maker']['live_time']))
		es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['defcoord'], _sctf_opt['flags'][flag]['x'], _sctf_opt['flags'][flag]['y'], z1, _sctf_opt['flag_maker']['live_time'], rgba))
		es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['x'], _sctf_opt['flags'][flag]['y'], z1, x1, _sctf_opt['flags'][flag]['y'], z1, _sctf_opt['flag_maker']['live_time'], rgba))
		es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['x'], _sctf_opt['flags'][flag]['y'], z2, x1, _sctf_opt['flags'][flag]['y'], z2, _sctf_opt['flag_maker']['live_time'], rgba))
		es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (x1, _sctf_opt['flags'][flag]['y'], z2, x1, _sctf_opt['flags'][flag]['y'], z1, _sctf_opt['flag_maker']['live_time'], rgba))
		if _sctf_opt['flags'][flag]['team'] == 3:
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['x'], _sctf_opt['flags'][flag]['y'], z1, x1, _sctf_opt['flags'][flag]['y'], z2, _sctf_opt['flag_maker']['live_time'], rgba))
		else:
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['x'], _sctf_opt['flags'][flag]['y'], z2, x1, _sctf_opt['flags'][flag]['y'], z1, _sctf_opt['flag_maker']['live_time'], rgba))
			
		if _sctf_opt['flags'][flag]['status'] == 2:
			z1 = _sctf_opt['flags'][flag]['dz'] + _sctf_opt['flag_maker']['drop']['z1']
			z2 = z1 - _sctf_opt['flag_maker']['drop']['z2']
			x1 = _sctf_opt['flags'][flag]['dx'] + _sctf_opt['flag_maker']['drop']['x1']
			#es.server.cmd("est_Effect 11 #h 0 \"sprites/blueglow1.vmt\" %s 1.05412 1 255" % _sctf_opt['flags'][flag]['defcoord'])
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['currentcoord'], _sctf_opt['flags'][flag]['dx'], _sctf_opt['flags'][flag]['dy'], z1, _sctf_opt['flag_maker']['live_time'], defrgba))
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['dx'], _sctf_opt['flags'][flag]['dy'], z1, x1, _sctf_opt['flags'][flag]['dy'], z1, _sctf_opt['flag_maker']['live_time'], defrgba))
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (_sctf_opt['flags'][flag]['dx'], _sctf_opt['flags'][flag]['dy'], z2, x1, _sctf_opt['flags'][flag]['dy'], z2, _sctf_opt['flag_maker']['live_time'], defrgba))
			es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %s %f 2 2 %s" % (x1, _sctf_opt['flags'][flag]['dy'], z2, x1, _sctf_opt['flags'][flag]['dy'], z1, _sctf_opt['flag_maker']['live_time'], defrgba))
			if _sctf_opt['flags'][flag]['team'] == 3:
				es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %f %i 2 2 %s" % (_sctf_opt['flags'][flag]['dx'], _sctf_opt['flags'][flag]['dy'], z1, x1, _sctf_opt['flags'][flag]['dy'], z2, _sctf_opt['flag_maker']['live_time'], defrgba))
			else:
				es.server.cmd("est_Effect 3 #h 0 \"sprites/laserbeam.vmt\" %s %s %s %s %s %f %i 2 2 %s" % (_sctf_opt['flags'][flag]['dx'], _sctf_opt['flags'][flag]['dy'], z2, x1, _sctf_opt['flags'][flag]['dy'], z1, _sctf_opt['flag_maker']['live_time'], defrgba))
					
def checkFlags():
	global _sctf_opt
	for flag in _sctf_opt['flags']:
		if not _sctf_opt['flags'][flag].has_key('defcoord'):
			continue
		if _sctf_opt['flags'][flag]['defcoord'] == "0 0 0":
			continue

		es.set("_sctf_temp", 0)
		
		filter = "#c!d!b"
		flagcolor = "Blue"
		trueflagcolor = "Red"
		opteam = 3
		if _sctf_opt['flags'][flag]['team'] == 3:
			filter = "#t!d!b"
			flagcolor = "Red"
			trueflagcolor = "Blue"
			opteam = 2

		opteamString = "ctf_%i" % opteam
		if _sctf_opt['flags'][flag]['status'] == 0:
			es.server.cmd("est_nearcoord _sctf_temp %s 50 %s \"None\"" % (filter, _sctf_opt['flags'][flag]['defcoord']))
			userid = int(es.ServerVar("_sctf_temp"))
			if userid > 0:
				captureFlag(userid, flag)

			if not _sctf_opt['flags'][opteamString].has_key('defcoord'):
				continue
			if _sctf_opt['flags'][opteamString]['defcoord'] == "0 0 0":
				continue

			userid = int(_sctf_opt['flags'][opteamString]['owner'])
			if userid > 0:
				es.set("_sctf_temp", 0)
				es.server.cmd("est_nearcoord _sctf_temp %i 50 %s \"None\"" % (userid, _sctf_opt['flags'][flag]['defcoord']))
				
				if int(es.ServerVar("_sctf_temp")) == userid:
					#pteam = es.getplayerteam(userid)
					pname = es.getplayername(userid)
					psteamid = es.getplayersteamid(userid)
					
					es.centermsg("%s Team Score! (%s)" % (trueflagcolor, pname))
					es.msg("\x04SCTF:\x03 %s\x01 Team Score! (\x03%s\x01)" % (trueflagcolor, pname))
					#todo if (server_var(sctf_flag_score_add_kills_for_team) != 0) then es est_KillAdd #t server_var(sctf_flag_score_add_kills_for_team)
					#todo es_msg #multi #green SCTF:#default Red Team Wins#lightgreen server_var(sctf_flag_score_add_kills_for_team)#default Points For Flag Score!
					
					es.emitsound("player", userid, "weapons/explode3.wav" ,1.0, 0.5)
					es.emitsound("player", userid, "weapons/explode4.wav" ,1.0, 0.5)
					es.emitsound("player", userid, "weapons/explode5.wav" ,1.0, 0.5)
					
					if sctf_sacrifice_for_score:
						es.server.queuecmd("est_slay %i\nest_deathAdd %i -1" % (userid, userid))
					
					if sctf_score_for_score_flag:
						es.server.queuecmd("est_KillAdd %i %i" % (userid, int(sctf_score_for_score_flag)))
						es.tell(userid, "\x04SCTF:\x01 You win\x03 %i\x01 Kill(s) for\x03 Flag Score\x01!" % int(sctf_score_for_score_flag))
					
					flagScoreKey = trueflagcolor.lower()+"_score"
					_sctf_opt['game_options'][flagScoreKey] += 1
					
					resetFlags(opteamString)
					# todo es est_SetPlayerColor server_var(sctf_coord) 255 255 255 255

					es.event("initialize", "sctf_flag")
					es.event("setint", "sctf_flag", "userid", userid)
					es.event("setstring", "sctf_flag", "team", trueflagcolor.lower())
					es.event("setint", "sctf_flag", "rason", 2)
					es.event("setstring", "sctf_flag", "rason_sz", "score")
					es.event("fire", "sctf_flag")
					
					if _sctf_opt['game_options']['score_limit'] > 0 and _sctf_opt['game_options'][flagScoreKey] >= _sctf_opt['game_options']['score_limit']:
						endGame()
					else:
						scoreSound = _sctf_opt['game_sounds'][trueflagcolor.lower()+"_team_score"]
						if scoreSound is not None:
							myPlayerList = playerlib.getPlayerList()
							for fuserid in myPlayerList:
								es.playsound(fuserid.userid, scoreSound, 1.0)
							
					_sctf_stats.give('flagsScored', psteamid)
					
	
		elif _sctf_opt['flags'][flag]['status'] == 2:
			if _sctf_opt['flags'][flag]['timedrop'] > -1:
				_sctf_opt['flags'][flag]['timedrop'] -= 1
							
			if _sctf_opt['flags'][flag]['timedrop'] == 0 or _sctf_opt['flags'][flag]['timedrop'] == -1:
				resetFlags(flag)
								
				es.centermsg("%s Flag returned! (Time)" % _sctf_opt['flags'][flag]['color'])
				es.msg("\x04SCTF:\x03 %s\x01 Flag\x01 returned! (\x03Time\x01)" % _sctf_opt['flags'][flag]['color'])
				
				soundToPlay = _sctf_opt['game_sounds'][_sctf_opt['flags'][flag]['color'].lower() + "_flag_return"]
				if soundToPlay is not None:
					myPlayerList = playerlib.getPlayerList()
					for userid in myPlayerList:
						es.playsound(userid.userid, soundToPlay, 1.0)
					
				es.event("initialize", "sctf_flag")
				es.event("setint", "sctf_flag", "userid", 0)
				es.event("setstring", "sctf_flag", "team", trueflagcolor.lower())
				es.event("setint", "sctf_flag", "rason", 4)
				es.event("setstring", "sctf_flag", "rason_sz", "return")
				es.event("fire", "sctf_flag")
			else:
				es.set("_sctf_temp", 0)
				es.server.cmd("est_nearcoord _sctf_temp #l!b 50 %s \"None \"" % _sctf_opt['flags'][flag]['currentcoord'])
				
				userid = int(es.ServerVar("_sctf_temp"))
				if userid > 0:
					pteam = es.getplayerteam(userid)
					pname = es.getplayername(userid)
					psteamid = es.getplayersteamid(userid)

					if int(pteam) == _sctf_opt['flags'][flag]['team']:
						resetFlags(flag)
						
						soundToPlay = _sctf_opt['game_sounds'][_sctf_opt['flags'][flag]['color'].lower()+"_flag_return"]
						if soundToPlay is not None:
							myPlayerList = playerlib.getPlayerList()
							for fuserid in myPlayerList:
								es.playsound(fuserid.userid, soundToPlay, 1.0)
						
						es.centermsg("%s Flag returned! (%s)" % (_sctf_opt['flags'][flag]['color'], pname))
						es.msg("\x04SCTF:\x03 %s\x01 Flag\x01 returned! (\x03%s\x01)" % (_sctf_opt['flags'][flag]['color'], pname))
						if int(sctf_score_for_return_flag) > 0:
							es.server.cmd("est_KillAdd %i %i" % (userid, int(sctf_score_for_return_flag))) 
							es.tell(userid, "\x04SCTF:\x01 You won\x03 %i\x01 Kill(s) for Flag Return" % int(sctf_score_for_return_flag))
							
						es.event("initialize", "sctf_flag")
						es.event("setint", "sctf_flag", "userid", userid)
						es.event("setstring", "sctf_flag", "team", trueflagcolor.lower())
						es.event("setint", "sctf_flag", "rason", 4)
						es.event("setstring", "sctf_flag", "rason_sz", "return")
						es.event("fire", "sctf_flag")

						_sctf_stats.give('flagsReturned', psteamid)
						
					else:
						captureFlag(userid, flag, True)

	if int(sctf_show_flag_status_hud):
		_sctf_flagsMngr.showStatusHud()
	#drawFlags()

def sctf_delayed_funcs(name, userid = 0):
	if int(userid) > 0:
		if not es.exists("userid", userid):
			return False
		
	if name == "repeat1s":
		if int(_sctf_opt['game_options']['game_time']) > 0:
			_sctf_opt['game_options']['game_time'] -= 1
			if _sctf_opt['game_options']['game_time'] == 0 or _sctf_opt['game_options']['game_time'] == -1:
				endGame()
				return True

		#checkFlags()
		_sctf_flagsMngr.checkFlagsDrop()
		if sctf_show_flag_status_hud:
			_sctf_flagsMngr.showStatusHud()
		gamethread.delayedname(1, "repeat1s", sctf_delayed_funcs, ("repeat1s"))
		return True
	if name == "clean":
		es.server.queuecmd("est_RemoveIdle weapon_;est_RemoveIdle item_;est_DeleteRagDolls")
		"""
		entlist = es.createentitylist()
		for index in entlist:
			if entlist[index]['classname'].startswith('weapon_') or entlist[index]['classname'].startswith('item_') or entlist[index]['classname'] == "cs_ragdoll":
				if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == -1:
					es.server.queuecmd('es_xremove %s' % index)
		"""
		gamethread.delayedname(_sctf_opt['game_options']['clean_idle'], "clean_idle", sctf_delayed_funcs, ("clean"))
		return True
	if name == "welcome":
		es.tell(userid, "\x04SCTF:\x03 Capture The Flag\x01 Mod\x01, version: \x03%s\n\x04SCTF:\x01 Written By:\x03 sn4k3\x01 AKA\x03 Tiago Conceicao\n\x04Visit:\x01 http://addons.eventscripts.com/addons/view/SCTF\n" % (sctf_version))
		return True
	if name == "autorespawn":
		if playerlib.getPlayer(userid).attributes['isdead']: # user is dead
			nt.spawnPlayer(userid)
		return True