//=========== (C) Copyright 2008 SCTF All rights reserved. ===========
//
// Events triggered by SCTF mod


// No spaces in event names, max length 32
// All strings are case sensitive
// total game event byte length must be < 1024
//
// valid data key types are:
//   none   : value is not networked
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit

"sctf_events"
{
	"sctf_flag"	// When something happen to a flag
	{
		"userid"	"short"		// userid of the person that make the action
		"team"		"string"	// Team color (blue OR red) use es_userteam to know the teamindex
		"rason"		"byte"		// The event fire rason (1 = captured | 2 = score | 3 = drop | 4 = return)
		"rason_sz"	"string"	// The event fire rason in string text
	}
	"sctf_gameend" // Happen when GameEnd by SCTF time end or flag score reach
	{
		"winners"		"byte"	// What team win the game
		"winners_score"	"short"	// Winner team score
		"lossers"		"byte"	// What team lost the game
		"lossers_score" "short"	// Lossers team score
		"timeleft"		"short"	// Timeleft to end game (0 = Game end by time | -1 OR > 0 = End by flag Score)
		"draw"			"bool"	// Game end in draw
	}
}
